/*
 * Decompiled with CFR 0.152.
 */
package com.dacrt.SBIABackend.service;

import com.dacrt.SBIABackend.dto.requestDto.DetalleUnidadAdscripcionRequestDto;
import com.dacrt.SBIABackend.dto.requestDto.UnidadAdscripcionRequestDto;
import com.dacrt.SBIABackend.dto.responseDto.DetalleUnidadAdscripcionResponseDto;
import com.dacrt.SBIABackend.dto.responseDto.UnidadAdscripcionResponseDto;
import com.dacrt.SBIABackend.entity.Parametros;
import com.dacrt.SBIABackend.entity.UnidadAdscripcion;
import com.dacrt.SBIABackend.repository.ParametrosRepository;
import com.dacrt.SBIABackend.repository.UnidadAdscripcionRepository;
import com.dacrt.SBIABackend.service.UnidadAdscripcionService;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.transaction.Transactional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@Transactional
public class UnidadAdscripcionServiceImpl
implements UnidadAdscripcionService {
    @Autowired
    private UnidadAdscripcionRepository unidadAdscripcionRepository;
    @Autowired
    private ParametrosRepository parametrosRepository;
    Date fechaActual = new Date();

    @Override
    public UnidadAdscripcionResponseDto addUnidadAdscripcion(UnidadAdscripcionRequestDto unidadAdscripcionRequestDto) {
        UnidadAdscripcion unidadAdscripcion = this.convertirDTOAEntidad(unidadAdscripcionRequestDto);
        this.unidadAdscripcionRepository.save(unidadAdscripcion);
        UnidadAdscripcionResponseDto unidadAdscripcionResponseDto = new UnidadAdscripcionResponseDto();
        unidadAdscripcionResponseDto.setCdUnidad(unidadAdscripcion.getCdUnidad());
        unidadAdscripcionResponseDto.setNombre(unidadAdscripcion.getNombre());
        unidadAdscripcionResponseDto.setDescripcion(unidadAdscripcion.getDescripcion());
        unidadAdscripcionResponseDto.setActivo(unidadAdscripcion.getActivo());
        unidadAdscripcionResponseDto.setTipoClasificacion(unidadAdscripcion.getTipoClasificacion());
        unidadAdscripcionResponseDto.setFechaRegistro(this.fechaActual);
        unidadAdscripcionResponseDto.setFechaModificacion(unidadAdscripcion.getFechaModificacion());
        unidadAdscripcionResponseDto.setUsuario(unidadAdscripcion.getUsuario());
        return unidadAdscripcionResponseDto;
    }

    @Override
    public List<DetalleUnidadAdscripcionResponseDto> getUnidadesAdscripcion() {
        ArrayList<DetalleUnidadAdscripcionResponseDto> listaUnidadesAdscripcion = new ArrayList<DetalleUnidadAdscripcionResponseDto>();
        List unidadesAdscripcion = StreamSupport.stream(this.unidadAdscripcionRepository.findAll().spliterator(), false).collect(Collectors.toList());
        for (UnidadAdscripcion unidadAdscripcion : unidadesAdscripcion) {
            Optional<Parametros> deEstatus = this.parametrosRepository.findByIdtablaAndValor("ESTATUS", String.valueOf(unidadAdscripcion.getActivo()));
            int id_estatus = Integer.parseInt(deEstatus.get().getValor());
            String estatus = deEstatus.get().getNombre();
            String boton = id_estatus == 1 ? "Desactivar" : "Activar";
            Optional<Parametros> deClasificacion = this.parametrosRepository.findByIdtablaAndValor("TIPOCLASIFICACION", String.valueOf(unidadAdscripcion.getTipoClasificacion()));
            int id_tipoClasificacion = Integer.parseInt(deClasificacion.get().getValor());
            String tipoClasificacion = deClasificacion.get().getNombre();
            DetalleUnidadAdscripcionResponseDto detalleUnidadAdscripcion = new DetalleUnidadAdscripcionResponseDto(unidadAdscripcion.getIdUnidadAdscripcion(), unidadAdscripcion.getCdUnidad(), unidadAdscripcion.getNombre(), unidadAdscripcion.getDescripcion(), id_estatus, estatus, boton, id_tipoClasificacion, tipoClasificacion, unidadAdscripcion.getUsuario(), unidadAdscripcion.getFechaRegistro(), unidadAdscripcion.getFechaModificacion());
            listaUnidadesAdscripcion.add(detalleUnidadAdscripcion);
        }
        return listaUnidadesAdscripcion;
    }

    @Override
    public DetalleUnidadAdscripcionResponseDto getUnidadAdscripcionById(Integer idUnidadAdscripcion) {
        UnidadAdscripcion unidadAdscripcion = this.getUnidadAdscripcion(idUnidadAdscripcion);
        Optional<Parametros> deEstatus = this.parametrosRepository.findByIdtablaAndValor("ESTATUS", String.valueOf(unidadAdscripcion.getActivo()));
        int id_estatus = Integer.parseInt(deEstatus.get().getValor());
        String boton = id_estatus == 1 ? "Desactivar" : "Activar";
        String estatus = deEstatus.get().getNombre();
        Optional<Parametros> deClasificacion = this.parametrosRepository.findByIdtablaAndValor("TIPOCLASIFICACION", String.valueOf(unidadAdscripcion.getTipoClasificacion()));
        int id_tipoClasificacion = Integer.parseInt(deClasificacion.get().getValor());
        String tipoClasificacion = deClasificacion.get().getNombre();
        DetalleUnidadAdscripcionResponseDto detalleUnidadAdscripcionResponseDto = new DetalleUnidadAdscripcionResponseDto(unidadAdscripcion.getIdUnidadAdscripcion(), unidadAdscripcion.getCdUnidad(), unidadAdscripcion.getNombre(), unidadAdscripcion.getDescripcion(), id_estatus, estatus, boton, id_tipoClasificacion, tipoClasificacion, unidadAdscripcion.getUsuario(), unidadAdscripcion.getFechaRegistro(), unidadAdscripcion.getFechaModificacion());
        return detalleUnidadAdscripcionResponseDto;
    }

    @Override
    public UnidadAdscripcion getUnidadAdscripcion(Integer idUnidadAdscripcion) {
        UnidadAdscripcion unidadAdscripcion = this.unidadAdscripcionRepository.findById(idUnidadAdscripcion).orElseThrow(() -> new IllegalArgumentException("No se encuentra la unidad de Adscripci\u00f3n con id: " + idUnidadAdscripcion));
        return unidadAdscripcion;
    }

    @Override
    public boolean existsByNombre(UnidadAdscripcionRequestDto unidadAdscripcionRequestDto) {
        return this.unidadAdscripcionRepository.existsByNombre(unidadAdscripcionRequestDto.getNombre());
    }

    @Override
    public UnidadAdscripcion convertirDTOAEntidad(UnidadAdscripcionRequestDto unidadAdscripcionRequestDto) {
        UnidadAdscripcion unidadAdscripcion = new UnidadAdscripcion();
        unidadAdscripcion.setCdUnidad(unidadAdscripcionRequestDto.getCdUnidad());
        unidadAdscripcion.setNombre(unidadAdscripcionRequestDto.getNombre());
        unidadAdscripcion.setDescripcion(unidadAdscripcionRequestDto.getDescripcion());
        unidadAdscripcion.setActivo(unidadAdscripcionRequestDto.getActivo());
        unidadAdscripcion.setTipoClasificacion(unidadAdscripcionRequestDto.getTipoClasificacion());
        unidadAdscripcion.setFechaRegistro(unidadAdscripcionRequestDto.getFechaRegistro());
        unidadAdscripcion.setFechaModificacion(unidadAdscripcionRequestDto.getFechaModificacion());
        unidadAdscripcion.setUsuario(unidadAdscripcionRequestDto.getUsuario());
        return unidadAdscripcion;
    }

    @Override
    public boolean existsByCdUnidad(String cdUnidad) {
        return this.unidadAdscripcionRepository.existsByCdUnidad(cdUnidad);
    }

    @Override
    public boolean existsById(Integer idUnidadAdscripcion) {
        return this.unidadAdscripcionRepository.existsById(idUnidadAdscripcion);
    }

    @Override
    public Optional<UnidadAdscripcion> getByNombre(String nombre) {
        return this.unidadAdscripcionRepository.findByNombre(nombre);
    }

    @Override
    public Optional<UnidadAdscripcion> getByCdUnidad(String cdUnidad) {
        return this.unidadAdscripcionRepository.findByCdUnidad(cdUnidad);
    }

    @Override
    public Optional<UnidadAdscripcion> getOne(Integer idUnidadAdscripcion) {
        return this.unidadAdscripcionRepository.findById(idUnidadAdscripcion);
    }

    @Override
    public void save(UnidadAdscripcion unidadAdscripcion) {
        this.unidadAdscripcionRepository.save(unidadAdscripcion);
    }

    @Override
    public boolean existsByNombre(DetalleUnidadAdscripcionRequestDto detalleUnidadAdscripcionRequestDto) {
        return this.unidadAdscripcionRepository.existsByNombre(detalleUnidadAdscripcionRequestDto.getNombre());
    }
}

