/*
 * Decompiled with CFR 0.152.
 */
package com.dacrt.SBIABackend.service;

import com.dacrt.SBIABackend.dto.responseDto.DetalleTipificacionRecursoResponseDto;
import com.dacrt.SBIABackend.entity.Parametros;
import com.dacrt.SBIABackend.entity.TipificacionRecurso;
import com.dacrt.SBIABackend.repository.ParametrosRepository;
import com.dacrt.SBIABackend.repository.TipificacionRecursoRepository;
import com.dacrt.SBIABackend.service.TificacionRecursoService;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.transaction.Transactional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@Transactional
public class TificacionRecursoServiceImpl
implements TificacionRecursoService {
    @Autowired
    TipificacionRecursoRepository tipificacionRecursoRepository;
    @Autowired
    private ParametrosRepository parametrosRepository;
    Date fechaActual = new Date();

    @Autowired
    public TificacionRecursoServiceImpl(TipificacionRecursoRepository tipificacionRecursoRepository) {
        this.tipificacionRecursoRepository = tipificacionRecursoRepository;
    }

    @Override
    public List<DetalleTipificacionRecursoResponseDto> getTipificacionRecursos() {
        ArrayList<DetalleTipificacionRecursoResponseDto> listaDetalleTipificacionRecurso = new ArrayList<DetalleTipificacionRecursoResponseDto>();
        List recursos = StreamSupport.stream(this.tipificacionRecursoRepository.findAll().spliterator(), false).collect(Collectors.toList());
        for (TipificacionRecurso tipificacionRecurso : recursos) {
            Optional<Parametros> deEstatus = this.parametrosRepository.findByIdtablaAndValor("ESTATUS", String.valueOf(tipificacionRecurso.getActivo()));
            int id_estatus = Integer.parseInt(deEstatus.get().getValor());
            String boton = id_estatus == 1 ? "Desactivar" : "Activar";
            String estatus = deEstatus.get().getNombre();
            DetalleTipificacionRecursoResponseDto detalleTipificacionRecurso = new DetalleTipificacionRecursoResponseDto(tipificacionRecurso.getId_tiporecurso(), tipificacionRecurso.getNombre(), tipificacionRecurso.getActivo(), estatus, boton, tipificacionRecurso.getUsuario(), tipificacionRecurso.getFechaRegistro(), tipificacionRecurso.getFechaModificacion());
            listaDetalleTipificacionRecurso.add(detalleTipificacionRecurso);
        }
        return listaDetalleTipificacionRecurso;
    }

    @Override
    public DetalleTipificacionRecursoResponseDto getTipificacionRecursoById(Integer id_tiporecurso) {
        String boton = "";
        TipificacionRecurso tipificacionRecurso = this.getTipificacionRecurso(id_tiporecurso);
        Optional<Parametros> deEstatus = this.parametrosRepository.findByIdtablaAndValor("ESTATUS", String.valueOf(tipificacionRecurso.getActivo()));
        int id_estatus = Integer.parseInt(deEstatus.get().getValor());
        boton = id_estatus == 1 ? "Desactivar" : "Activar";
        String estatus = deEstatus.get().getNombre();
        DetalleTipificacionRecursoResponseDto detalleTipificacionRecursoResponseDto = new DetalleTipificacionRecursoResponseDto(tipificacionRecurso.getId_tiporecurso(), tipificacionRecurso.getNombre(), tipificacionRecurso.getActivo(), estatus, boton, tipificacionRecurso.getUsuario(), tipificacionRecurso.getFechaRegistro(), tipificacionRecurso.getFechaModificacion());
        return detalleTipificacionRecursoResponseDto;
    }

    @Override
    public TipificacionRecurso getTipificacionRecurso(Integer id_tiporecurso) {
        TipificacionRecurso tipificacionRecurso = (TipificacionRecurso)this.tipificacionRecursoRepository.findById(id_tiporecurso).orElseThrow(() -> new IllegalArgumentException("No se encuentra el tipo de recurso con id: " + id_tiporecurso));
        return tipificacionRecurso;
    }

    @Override
    public Optional<TipificacionRecurso> getByNombre(String nombre) {
        return this.tipificacionRecursoRepository.findByNombre(nombre);
    }

    @Override
    public TipificacionRecurso addTipificacionRecurso(TipificacionRecurso tipificacionRecurso) {
        return (TipificacionRecurso)this.tipificacionRecursoRepository.save(tipificacionRecurso);
    }

    @Override
    public TipificacionRecurso deleteTipificacionRecurso(Integer id_tiporecurso, TipificacionRecurso tipificacionRecurso) {
        return (TipificacionRecurso)this.tipificacionRecursoRepository.save(tipificacionRecurso);
    }

    @Override
    public boolean existsByNombre(String nombre) {
        return this.tipificacionRecursoRepository.existsByNombre(nombre);
    }

    @Override
    public boolean existsById(Integer id_tiporecurso) {
        return this.tipificacionRecursoRepository.existsById(id_tiporecurso);
    }

    @Override
    public TipificacionRecurso editTipoRecurso(Integer id_tiporecurso, TipificacionRecurso tipoRecurso) {
        return (TipificacionRecurso)this.tipificacionRecursoRepository.save(tipoRecurso);
    }
}

