/*
 * Decompiled with CFR 0.152.
 */
package com.dacrt.SBIABackend.service;

import com.dacrt.SBIABackend.dto.requestDto.DetalleProveedoresRequestDto;
import com.dacrt.SBIABackend.dto.requestDto.ProveedoresRequestDto;
import com.dacrt.SBIABackend.dto.responseDto.DetalleProveedoresResponseDto;
import com.dacrt.SBIABackend.dto.responseDto.ProveedoresResponseDto;
import com.dacrt.SBIABackend.entity.Parametros;
import com.dacrt.SBIABackend.entity.Proveedores;
import com.dacrt.SBIABackend.repository.ParametrosRepository;
import com.dacrt.SBIABackend.repository.ProveedoresRepository;
import com.dacrt.SBIABackend.service.ProveedoresService;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.transaction.Transactional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@Transactional
public class ProveedoresServiceImpl
implements ProveedoresService {
    @Autowired
    private ProveedoresRepository proveedoresRepository;
    @Autowired
    private ParametrosRepository parametrosRepository;
    Date fechaActual = new Date();

    @Autowired
    public ProveedoresServiceImpl(ProveedoresRepository proveedoresRepository, ParametrosRepository parametrosRepository) {
        this.proveedoresRepository = proveedoresRepository;
        this.parametrosRepository = parametrosRepository;
    }

    @Override
    public ProveedoresResponseDto addProveedores(ProveedoresRequestDto proveedoresRequestDto) {
        Proveedores proveedores = new Proveedores();
        proveedores.setCdProveedores(proveedoresRequestDto.getCdProveedores());
        proveedores.setNombre(proveedoresRequestDto.getNombre());
        proveedores.setDescripcion(proveedoresRequestDto.getDescripcion());
        proveedores.setRuc(proveedoresRequestDto.getRuc());
        proveedores.setActivo(proveedoresRequestDto.getActivo());
        proveedores.setTipoProveedores(proveedoresRequestDto.getTipoProveedores());
        proveedores.setSoporta(proveedoresRequestDto.getSoporta());
        proveedores.setInfoContrato(proveedoresRequestDto.getInfoContrato());
        proveedores.setEmpRelacionado(proveedoresRequestDto.getEmpRelacionado());
        proveedores.setPoseeContraProvee(proveedoresRequestDto.getPoseeContraProvee());
        proveedores.setNombreContraProvee(proveedoresRequestDto.getNombreContraProvee());
        proveedores.setSoportaSol(proveedoresRequestDto.getSoportaSol());
        proveedores.setTiempoAtenc(proveedoresRequestDto.getTiempoAtenc());
        proveedores.setTiempoResp(proveedoresRequestDto.getTiempoResp());
        proveedores.setProcesaDatos(proveedoresRequestDto.getProcesaDatos());
        proveedores.setTmrpoProv(proveedoresRequestDto.getTmrpoProv());
        proveedores.setTmrtoProv(proveedoresRequestDto.getTmrtoProv());
        proveedores.setPoseeBCP(proveedoresRequestDto.getPoseeBCP());
        proveedores.setTelefonos(proveedoresRequestDto.getTelefonos());
        proveedores.setContactos(proveedoresRequestDto.getContactos());
        proveedores.setCorreos(proveedoresRequestDto.getCorreos());
        proveedores.setFechaModificacion(proveedoresRequestDto.getFechaModificacion());
        proveedores.setFechaRegistro(proveedoresRequestDto.getFechaRegistro());
        proveedores.setUsuario(proveedoresRequestDto.getUsuario());
        this.proveedoresRepository.save(proveedores);
        Proveedores proveedores2 = (Proveedores)this.proveedoresRepository.save(proveedores);
        ProveedoresResponseDto proveedoresResponseDto = new ProveedoresResponseDto();
        proveedoresResponseDto.setCdProveedores(proveedores2.getCdProveedores());
        proveedoresResponseDto.setNombre(proveedores2.getNombre());
        proveedoresResponseDto.setDescripcion(proveedores2.getDescripcion());
        proveedoresResponseDto.setRuc(proveedores2.getRuc());
        proveedoresResponseDto.setActivo(proveedores2.getActivo());
        proveedoresResponseDto.setTipoProveedores(proveedores2.getTipoProveedores());
        proveedoresResponseDto.setSoporta(proveedores2.getSoporta());
        proveedoresResponseDto.setInfoContrato(proveedores2.getInfoContrato());
        proveedoresResponseDto.setEmpRelacionado(proveedores2.getEmpRelacionado());
        proveedoresResponseDto.setPoseeContraProvee(proveedores2.getPoseeContraProvee());
        proveedoresResponseDto.setNombreContraProvee(proveedores2.getNombreContraProvee());
        proveedoresResponseDto.setSoportaSol(proveedores2.getSoportaSol());
        proveedoresResponseDto.setTiempoAtenc(proveedores2.getTiempoAtenc());
        proveedoresResponseDto.setTiempoResp(proveedores2.getTiempoResp());
        proveedoresResponseDto.setProcesaDatos(proveedores2.getProcesaDatos());
        proveedoresResponseDto.setTmrpoProv(proveedores2.getTmrpoProv());
        proveedoresResponseDto.setTmrtoProv(proveedores2.getTmrtoProv());
        proveedoresResponseDto.setPoseeBCP(proveedores2.getPoseeBCP());
        proveedoresResponseDto.setTelefonos(proveedores2.getTelefonos());
        proveedoresResponseDto.setContactos(proveedores2.getContactos());
        proveedoresResponseDto.setCorreos(proveedores2.getCorreos());
        proveedoresResponseDto.setFechaModificacion(proveedores2.getFechaModificacion());
        proveedoresResponseDto.setFechaRegistro(proveedores2.getFechaRegistro());
        proveedoresResponseDto.setUsuario(proveedores2.getUsuario());
        return proveedoresResponseDto;
    }

    @Override
    public DetalleProveedoresResponseDto editProveedores(Integer idProveedores, DetalleProveedoresRequestDto detalleProveedoresRequestDto) {
        Proveedores proveedores = (Proveedores)this.proveedoresRepository.getOne(idProveedores);
        proveedores.setCdProveedores(detalleProveedoresRequestDto.getCdProveedores());
        proveedores.setNombre(detalleProveedoresRequestDto.getNombre());
        proveedores.setDescripcion(detalleProveedoresRequestDto.getDescripcion());
        proveedores.setRuc(detalleProveedoresRequestDto.getRuc());
        proveedores.setActivo(detalleProveedoresRequestDto.getActivo());
        proveedores.setTipoProveedores(detalleProveedoresRequestDto.getTipoProveedores());
        proveedores.setSoporta(detalleProveedoresRequestDto.getSoporta());
        proveedores.setInfoContrato(detalleProveedoresRequestDto.getInfoContrato());
        proveedores.setEmpRelacionado(detalleProveedoresRequestDto.getEmpRelacionado());
        proveedores.setPoseeContraProvee(detalleProveedoresRequestDto.getPoseeContraProvee());
        proveedores.setNombreContraProvee(detalleProveedoresRequestDto.getNombreContraProvee());
        proveedores.setSoportaSol(detalleProveedoresRequestDto.getSoportaSol());
        proveedores.setTiempoAtenc(detalleProveedoresRequestDto.getTiempoAtenc());
        proveedores.setTiempoResp(detalleProveedoresRequestDto.getTiempoResp());
        proveedores.setProcesaDatos(detalleProveedoresRequestDto.getProcesaDatos());
        proveedores.setTmrpoProv(detalleProveedoresRequestDto.getTmrpoProv());
        proveedores.setTmrtoProv(detalleProveedoresRequestDto.getTmrtoProv());
        proveedores.setPoseeBCP(detalleProveedoresRequestDto.getPoseeBCP());
        proveedores.setTelefonos(detalleProveedoresRequestDto.getTelefonos());
        proveedores.setContactos(detalleProveedoresRequestDto.getContactos());
        proveedores.setCorreos(detalleProveedoresRequestDto.getCorreos());
        proveedores.setFechaModificacion(detalleProveedoresRequestDto.getFechaModificacion());
        proveedores.setFechaRegistro(detalleProveedoresRequestDto.getFechaRegistro());
        proveedores.setUsuario(detalleProveedoresRequestDto.getUsuario());
        this.proveedoresRepository.save(proveedores);
        DetalleProveedoresResponseDto proveedoresResponseDto = new DetalleProveedoresResponseDto();
        proveedoresResponseDto.setCdProveedores(proveedores.getCdProveedores());
        proveedoresResponseDto.setNombre(proveedores.getNombre());
        proveedoresResponseDto.setDescripcion(proveedores.getDescripcion());
        proveedoresResponseDto.setRuc(proveedores.getRuc());
        proveedoresResponseDto.setActivo(proveedores.getActivo());
        proveedoresResponseDto.setTipoProveedores(proveedores.getTipoProveedores());
        proveedoresResponseDto.setSoporta(proveedores.getSoporta());
        proveedoresResponseDto.setInfoContrato(proveedores.getInfoContrato());
        proveedoresResponseDto.setEmpRelacionado(proveedores.getEmpRelacionado());
        proveedoresResponseDto.setPoseeContraProvee(proveedores.getPoseeContraProvee());
        proveedoresResponseDto.setNombreContraProvee(proveedores.getNombreContraProvee());
        proveedoresResponseDto.setSoportaSol(proveedores.getSoportaSol());
        proveedoresResponseDto.setTiempoAtenc(proveedores.getTiempoAtenc());
        proveedoresResponseDto.setTiempoResp(proveedores.getTiempoResp());
        proveedoresResponseDto.setProcesaDatos(proveedores.getProcesaDatos());
        proveedoresResponseDto.setTmrpoProv(proveedores.getTmrpoProv());
        proveedoresResponseDto.setTmrtoProv(proveedores.getTmrtoProv());
        proveedoresResponseDto.setPoseeBCP(proveedores.getPoseeBCP());
        proveedoresResponseDto.setTelefonos(proveedores.getTelefonos());
        proveedoresResponseDto.setContactos(proveedores.getContactos());
        proveedoresResponseDto.setCorreos(proveedores.getCorreos());
        proveedoresResponseDto.setFechaModificacion(proveedores.getFechaModificacion());
        proveedoresResponseDto.setFechaRegistro(proveedores.getFechaRegistro());
        proveedoresResponseDto.setUsuario(proveedores.getUsuario());
        return proveedoresResponseDto;
    }

    @Override
    public List<DetalleProveedoresResponseDto> getProveedores() {
        ArrayList<DetalleProveedoresResponseDto> listaDetalleProveedores = new ArrayList<DetalleProveedoresResponseDto>();
        List proveedores = StreamSupport.stream(this.proveedoresRepository.findAll().spliterator(), false).collect(Collectors.toList());
        for (Proveedores proveedor : proveedores) {
            Optional<Parametros> activo = this.parametrosRepository.findByIdtablaAndValor("ESTATUS", String.valueOf(proveedor.getActivo()));
            Optional<Parametros> tipoProveedor = this.parametrosRepository.findByIdtablaAndValor("TIPOPROVEEDORES", String.valueOf(proveedor.getTipoProveedores()));
            Optional<Parametros> soporta = this.parametrosRepository.findByIdtablaAndValor("SOPORTA", String.valueOf(proveedor.getSoporta()));
            Optional<Parametros> empRelacionado = this.parametrosRepository.findByIdtablaAndValor("EMPRELACIONADO", String.valueOf(proveedor.getEmpRelacionado()));
            Optional<Parametros> proveedorContra = this.parametrosRepository.findByIdtablaAndValor("POSEECONTRAPROVEE", String.valueOf(proveedor.getPoseeContraProvee()));
            Optional<Parametros> soportaSol = this.parametrosRepository.findByIdtablaAndValor("SOPORTASOL", String.valueOf(proveedor.getSoportaSol()));
            Optional<Parametros> procesaDatos = this.parametrosRepository.findByIdtablaAndValor("PROCESADATOS", String.valueOf(proveedor.getProcesaDatos()));
            Optional<Parametros> posseBCP = this.parametrosRepository.findByIdtablaAndValor("POSEEBCP", String.valueOf(proveedor.getPoseeBCP()));
            int idActivo = Integer.parseInt(activo.get().getValor());
            String deActivo = activo.get().getNombre();
            String boton = idActivo == 1 ? "Desactivar" : "Activar";
            int idTipoProveedor = Integer.parseInt(tipoProveedor.get().getValor());
            String deTipoProveedor = tipoProveedor.get().getNombre();
            int idSoporta = Integer.parseInt(soporta.get().getValor());
            String deSoporta = soporta.get().getNombre();
            int idEmpRelacionado = Integer.parseInt(empRelacionado.get().getValor());
            String deEmpRelacionado = empRelacionado.get().getNombre();
            int idSoportaSol = Integer.parseInt(soportaSol.get().getValor());
            String deSoportaSol = soportaSol.get().getNombre();
            int idProveedorContra = Integer.parseInt(proveedorContra.get().getValor());
            String deProveedorContra = proveedorContra.get().getNombre();
            int idProcesaDatos = Integer.parseInt(procesaDatos.get().getValor());
            String deProcesaDatos = procesaDatos.get().getNombre();
            int idPosseBCP = Integer.parseInt(posseBCP.get().getValor());
            String dePosseBCP = posseBCP.get().getNombre();
            DetalleProveedoresResponseDto detalleProveedores = new DetalleProveedoresResponseDto(proveedor.getIdProveedores(), proveedor.getCdProveedores(), proveedor.getNombre(), proveedor.getDescripcion(), proveedor.getRuc(), idActivo, deActivo, boton, idTipoProveedor, deTipoProveedor, idSoporta, deSoporta, proveedor.getInfoContrato(), idEmpRelacionado, deEmpRelacionado, idProveedorContra, deProveedorContra, proveedor.getNombreContraProvee(), idSoportaSol, deSoportaSol, proveedor.getTiempoAtenc(), proveedor.getTiempoResp(), idProcesaDatos, deProcesaDatos, proveedor.getTmrtoProv(), proveedor.getTmrpoProv(), idPosseBCP, dePosseBCP, proveedor.getTelefonos(), proveedor.getContactos(), proveedor.getCorreos(), proveedor.getUsuario(), proveedor.getFechaRegistro(), proveedor.getFechaModificacion());
            listaDetalleProveedores.add(detalleProveedores);
        }
        return listaDetalleProveedores;
    }

    @Override
    public DetalleProveedoresResponseDto getProveedoresById(Integer idProveedores) {
        Proveedores proveedor = this.getProveedores(idProveedores);
        Optional<Parametros> activo = this.parametrosRepository.findByIdtablaAndValor("ESTATUS", String.valueOf(proveedor.getActivo()));
        Optional<Parametros> tipoProveedor = this.parametrosRepository.findByIdtablaAndValor("TIPOPROVEEDORES", String.valueOf(proveedor.getTipoProveedores()));
        Optional<Parametros> soporta = this.parametrosRepository.findByIdtablaAndValor("SOPORTA", String.valueOf(proveedor.getSoporta()));
        Optional<Parametros> empRelacionado = this.parametrosRepository.findByIdtablaAndValor("EMPRELACIONADO", String.valueOf(proveedor.getEmpRelacionado()));
        Optional<Parametros> proveedorContra = this.parametrosRepository.findByIdtablaAndValor("POSEECONTRAPROVEE", String.valueOf(proveedor.getPoseeContraProvee()));
        Optional<Parametros> soportaSol = this.parametrosRepository.findByIdtablaAndValor("SOPORTASOL", String.valueOf(proveedor.getSoportaSol()));
        Optional<Parametros> procesaDatos = this.parametrosRepository.findByIdtablaAndValor("PROCESADATOS", String.valueOf(proveedor.getProcesaDatos()));
        Optional<Parametros> posseBCP = this.parametrosRepository.findByIdtablaAndValor("POSEEBCP", String.valueOf(proveedor.getPoseeBCP()));
        int idActivo = Integer.parseInt(activo.get().getValor());
        String deActivo = activo.get().getNombre();
        String boton = idActivo == 1 ? "Desactivar" : "Activar";
        int idTipoProveedor = Integer.parseInt(tipoProveedor.get().getValor());
        String deTipoProveedor = tipoProveedor.get().getNombre();
        int idSoporta = Integer.parseInt(soporta.get().getValor());
        String deSoporta = soporta.get().getNombre();
        int idEmpRelacionado = Integer.parseInt(empRelacionado.get().getValor());
        String deEmpRelacionado = empRelacionado.get().getNombre();
        int idSoportaSol = Integer.parseInt(soportaSol.get().getValor());
        String deSoportaSol = soportaSol.get().getNombre();
        int idProveedorContra = Integer.parseInt(proveedorContra.get().getValor());
        String deProveedorContra = proveedorContra.get().getNombre();
        int idProcesaDatos = Integer.parseInt(procesaDatos.get().getValor());
        String deProcesaDatos = procesaDatos.get().getNombre();
        int idPosseBCP = Integer.parseInt(posseBCP.get().getValor());
        String dePosseBCP = posseBCP.get().getNombre();
        DetalleProveedoresResponseDto detalleProveedores = new DetalleProveedoresResponseDto(proveedor.getIdProveedores(), proveedor.getCdProveedores(), proveedor.getNombre(), proveedor.getDescripcion(), proveedor.getRuc(), idActivo, deActivo, boton, idTipoProveedor, deTipoProveedor, idSoporta, deSoporta, proveedor.getInfoContrato(), idEmpRelacionado, deEmpRelacionado, idProveedorContra, deProveedorContra, proveedor.getNombreContraProvee(), idSoportaSol, deSoportaSol, proveedor.getTiempoAtenc(), proveedor.getTiempoResp(), idProcesaDatos, deProcesaDatos, proveedor.getTmrtoProv(), proveedor.getTmrpoProv(), idPosseBCP, dePosseBCP, proveedor.getTelefonos(), proveedor.getContactos(), proveedor.getCorreos(), proveedor.getUsuario(), proveedor.getFechaRegistro(), proveedor.getFechaModificacion());
        return detalleProveedores;
    }

    @Override
    public Proveedores getProveedores(Integer idProveedores) {
        Proveedores proveedor = (Proveedores)this.proveedoresRepository.findById(idProveedores).orElseThrow(() -> new IllegalArgumentException("No se encuentra el proveedor con id: " + idProveedores));
        return proveedor;
    }

    @Override
    public ProveedoresResponseDto deleteProceso(Integer idProveedores) {
        return null;
    }

    @Override
    public boolean existsByNombre(String nombre) {
        return this.proveedoresRepository.existsByNombre(nombre);
    }

    @Override
    public boolean existsBycdProveedores(String cdProveedores) {
        return this.proveedoresRepository.existsBycdProveedores(cdProveedores);
    }

    @Override
    public boolean existsById(Integer idProveedores) {
        return this.proveedoresRepository.existsById(idProveedores);
    }

    @Override
    public Optional<Proveedores> getBycdProveedores(String cdProveedores) {
        return this.proveedoresRepository.findBycdProveedores(cdProveedores);
    }

    @Override
    public Optional<Proveedores> getByNombre(String nombre) {
        return this.proveedoresRepository.findByNombre(nombre);
    }

    @Override
    public Optional<Proveedores> getOne(Integer idProveedores) {
        return this.proveedoresRepository.findById(idProveedores);
    }

    @Override
    public void save(Proveedores proveedores) {
        this.proveedoresRepository.save(proveedores);
    }

    @Override
    public long countProveedores() {
        return this.proveedoresRepository.count();
    }
}

