/*
 * Decompiled with CFR 0.152.
 */
package com.dacrt.SBIABackend.service;

import com.dacrt.SBIABackend.Specifications.ParametroSpecifications;
import com.dacrt.SBIABackend.dto.responseDto.DetalleParametrosResponseDto;
import com.dacrt.SBIABackend.entity.Parametros;
import com.dacrt.SBIABackend.repository.ParametrosRepository;
import com.dacrt.SBIABackend.service.ParametrosService;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.transaction.Transactional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
@Transactional
public class ParametrosServiceImpl
implements ParametrosService {
    @Autowired
    private ParametrosRepository parametrosRepository;

    @Override
    public List<DetalleParametrosResponseDto> getParametros() {
        ArrayList<DetalleParametrosResponseDto> listaDetalleParametros = new ArrayList<DetalleParametrosResponseDto>();
        List parametros = StreamSupport.stream(this.parametrosRepository.findAll().spliterator(), false).collect(Collectors.toList());
        for (Parametros parametro : parametros) {
            Optional<Parametros> deEstatus = this.parametrosRepository.findByIdtablaAndValor("ESTATUS", String.valueOf(parametro.getActivo()));
            int id_estatus = Integer.parseInt(deEstatus.get().getValor());
            String boton = id_estatus == 1 ? "Desactivar" : "Activar";
            String estatus = deEstatus.get().getNombre();
            DetalleParametrosResponseDto detalleParametros = new DetalleParametrosResponseDto(parametro.getId_parametros(), parametro.getIdtabla(), parametro.getNombre(), parametro.getValor(), parametro.getActivo(), estatus, boton, parametro.getUsuario(), parametro.getFechaRegistro(), parametro.getFechaModificacion());
            listaDetalleParametros.add(detalleParametros);
        }
        return listaDetalleParametros;
    }

    @Override
    public List<Parametros> findAllByIdtabla(String Idtabla) {
        return this.parametrosRepository.findAllByIdtabla(Idtabla);
    }

    @Override
    public Optional<Parametros> getOne(Integer id_parametros) {
        return this.parametrosRepository.findById(id_parametros);
    }

    @Override
    public Optional<Parametros> getByNombre(String nombre) {
        return this.parametrosRepository.findByNombre(nombre);
    }

    @Override
    public Optional<Parametros> getByIdtablaAndValor(String idtabla, String valor) {
        return this.parametrosRepository.findByIdtablaAndValor(idtabla, valor);
    }

    @Override
    public List<Parametros> findByIdtablaAndNombreAndValor(String idtabla, String nombre, String valor) {
        return this.parametrosRepository.findByIdtablaAndNombreAndValor(idtabla, nombre, valor);
    }

    @Override
    public Optional<Parametros> getByIdtabla(String idtabla) {
        return this.parametrosRepository.findByIdtabla(idtabla);
    }

    @Override
    public void save(Parametros parametros) {
        this.parametrosRepository.save(parametros);
    }

    @Override
    public void delete(Integer id_parametros) {
        this.parametrosRepository.deleteById(id_parametros);
    }

    @Override
    public boolean existsById(Integer id_parametros) {
        return this.parametrosRepository.existsById(id_parametros);
    }

    @Override
    public boolean existsByNombre(String nombre) {
        return this.parametrosRepository.existsByNombre(nombre);
    }

    @Override
    public boolean existsByIdtablaAndNombreAndValor(String idtabla, String nombre, String valor) {
        return this.parametrosRepository.existsByIdtablaAndNombreAndValor(idtabla, nombre, valor);
    }

    @Override
    public List<Parametros> buscarParametro(String idtabla, String valor) {
        Specification<Parametros> spec = ParametroSpecifications.conCriterio(idtabla, valor);
        return this.parametrosRepository.findAll(spec);
    }

    @Override
    public Optional<Parametros> findByIdtablaAndNombre(String idtabla, String nombre) {
        return this.parametrosRepository.findByIdtablaAndNombre(idtabla, nombre);
    }

    @Override
    public Optional<Parametros> getByIdtablaAndNombreAndValor(String idtabla, String nombre, String valor) {
        return this.parametrosRepository.getByIdtablaAndNombreAndValor(idtabla, nombre, valor);
    }
}

