/*
 * Decompiled with CFR 0.152.
 */
package com.dacrt.SBIABackend.service;

import com.dacrt.SBIABackend.controler.EvaluacionesControler;
import com.dacrt.SBIABackend.dto.requestDto.DetalleEvaluacionesRequestDto;
import com.dacrt.SBIABackend.dto.requestDto.EvaluacionesRequestDto;
import com.dacrt.SBIABackend.dto.responseDto.DetalleEvaluacionesResponseDto;
import com.dacrt.SBIABackend.entity.Evaluaciones;
import com.dacrt.SBIABackend.entity.LineaOperacion;
import com.dacrt.SBIABackend.entity.Maestroevaluacion;
import com.dacrt.SBIABackend.entity.Parametros;
import com.dacrt.SBIABackend.entity.Proceso;
import com.dacrt.SBIABackend.entity.Unidad;
import com.dacrt.SBIABackend.repository.EvaluacionesRepository;
import com.dacrt.SBIABackend.repository.LineaOperacionRepository;
import com.dacrt.SBIABackend.repository.MaestroevaluacionesRepository;
import com.dacrt.SBIABackend.repository.ParametrosRepository;
import com.dacrt.SBIABackend.repository.ProcesoRepository;
import com.dacrt.SBIABackend.repository.UnidadRepository;
import com.dacrt.SBIABackend.security.service.UsuarioService;
import com.dacrt.SBIABackend.service.EvaluacionesService;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.transaction.Transactional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.stereotype.Service;

@Service
@Transactional
public class EvaluacionesServiceImpl
implements EvaluacionesService {
    @Autowired
    private UsuarioService usuarioService;
    @Autowired
    private EvaluacionesRepository evaluacionesRepository;
    @Autowired
    private MaestroevaluacionesRepository maestroEvaluacionesRepository;
    @Autowired
    private LineaOperacionRepository lineaOperacionRepository;
    @Autowired
    private ProcesoRepository procesoRepository;
    @Autowired
    private ParametrosRepository parametrosRepository;
    @Autowired
    private UnidadRepository unidadRepository;
    Logger logger = LoggerFactory.getLogger(EvaluacionesControler.class);
    Date fechaActual = new Date();

    @Autowired
    public EvaluacionesServiceImpl(EvaluacionesRepository evaluacionesRepository) {
        this.evaluacionesRepository = evaluacionesRepository;
    }

    @Override
    public Set<Unidad> buscarUnidades(String nombreUsuario) {
        Set<Unidad> unidades = this.usuarioService.buscarUnidades(nombreUsuario);
        return unidades;
    }

    @Override
    public List<DetalleEvaluacionesResponseDto> buscarEvaluaciones(Integer idUnidad) {
        List<Evaluaciones> evaluacionesResponseDtos = this.evaluacionesRepository.findEvaluacionesByUnidad(idUnidad);
        ArrayList<DetalleEvaluacionesResponseDto> detalleEvaluacionesResponseDto = new ArrayList<DetalleEvaluacionesResponseDto>();
        int rto2 = 0;
        for (Evaluaciones evaluaciones : evaluacionesResponseDtos) {
            Optional<Parametros> medida = this.parametrosRepository.findByIdtablaAndValor("MEDIDARTO", String.valueOf(evaluaciones.getMedidaRto()));
            String deMedida = medida.get().getNombre();
            Optional<Parametros> estado = this.parametrosRepository.findByIdtablaAndValor("ESTADO", String.valueOf(evaluaciones.getEstado()));
            String deEstado = estado.get().getNombre();
            if (evaluaciones.getMedidaRto() == 1) {
                rto2 = evaluaciones.getRto() / 60 / 24;
            }
            if (evaluaciones.getMedidaRto() == 2) {
                rto2 = evaluaciones.getRto() / 60;
            }
            if (evaluaciones.getMedidaRto() == 3) {
                rto2 = evaluaciones.getRto();
            }
            DetalleEvaluacionesResponseDto eval = new DetalleEvaluacionesResponseDto(evaluaciones.getIdEvaluacion(), evaluaciones.getIdMaestroEvaluacion().getIdMaestroEvaluacion(), evaluaciones.getIdMaestroEvaluacion().getNombreEvaluacion(), evaluaciones.getUnidad().getIdUnidad(), evaluaciones.getUnidad().getCdUnidad(), evaluaciones.getUnidad().getNombre(), evaluaciones.getLineaoperacion().getId_lineaoperacion(), evaluaciones.getLineaoperacion().getNombre(), evaluaciones.getProceso().getId_procesamiento(), evaluaciones.getProceso().getIdProceso(), evaluaciones.getProceso().getNombre(), rto2, evaluaciones.getMedidaRto(), deMedida, evaluaciones.getEstado(), deEstado, evaluaciones.getPromFact(), evaluaciones.getProcesoRequerido(), evaluaciones.getMcbo(), evaluaciones.getFechaEvalua(), evaluaciones.getUsuario(), evaluaciones.getFechaRegistro(), evaluaciones.getFechaModificacion(), evaluaciones.getFactor());
            detalleEvaluacionesResponseDto.add(eval);
            rto2 = 0;
        }
        return detalleEvaluacionesResponseDto;
    }

    @Override
    public Evaluaciones addEvaluaciones(EvaluacionesRequestDto evaluacionesRequestDto) {
        Evaluaciones evaluaciones = new Evaluaciones();
        Maestroevaluacion evaluac = new Maestroevaluacion();
        Optional evaluac2 = this.maestroEvaluacionesRepository.findById(evaluacionesRequestDto.getIdMaestroEvaluacion());
        evaluaciones.setIdMaestroEvaluacion((Maestroevaluacion)evaluac2.get());
        LineaOperacion linea = new LineaOperacion();
        Optional<LineaOperacion> linea2 = this.lineaOperacionRepository.findById(evaluacionesRequestDto.getId_lineaoperacion());
        evaluaciones.setLineaoperacion(linea2.get());
        Unidad unidad = new Unidad();
        Optional<Unidad> unidad2 = this.unidadRepository.findById(evaluacionesRequestDto.getIdUnidad());
        evaluaciones.setUnidad(unidad2.get());
        Proceso proceso = new Proceso();
        Optional proceso2 = this.procesoRepository.findById(evaluacionesRequestDto.getId_procesamiento());
        evaluaciones.setProceso((Proceso)proceso2.get());
        int rto = 0;
        if (evaluacionesRequestDto.getMedidaRto() == 1) {
            rto = evaluacionesRequestDto.getRto() * 24 * 60;
        }
        if (evaluacionesRequestDto.getMedidaRto() == 2) {
            rto = evaluacionesRequestDto.getRto() * 60;
        }
        if (evaluacionesRequestDto.getMedidaRto() == 3) {
            rto = evaluacionesRequestDto.getRto();
        }
        evaluaciones.setRto(rto);
        evaluaciones.setMedidaRto(evaluacionesRequestDto.getMedidaRto());
        evaluaciones.setEstado(1);
        evaluaciones.setPromFact(evaluacionesRequestDto.getPromFact());
        evaluaciones.setMcbo(evaluacionesRequestDto.getMcbo());
        evaluaciones.setProcesoRequerido(evaluacionesRequestDto.getProcesoRequerido());
        evaluaciones.setFechaEvalua(evaluacionesRequestDto.getFechaEvalua());
        evaluaciones.setFechaModificacion(evaluacionesRequestDto.getFechaModificacion());
        evaluaciones.setFechaRegistro(evaluacionesRequestDto.getFechaRegistro());
        evaluaciones.setUsuario(evaluacionesRequestDto.getUsuario());
        evaluaciones.setFactor(evaluacionesRequestDto.getFactores());
        return (Evaluaciones)this.evaluacionesRepository.save(evaluaciones);
    }

    @Override
    public boolean existsById(Integer idEvaluacion) {
        return this.evaluacionesRepository.existsById(idEvaluacion);
    }

    @Override
    public DetalleEvaluacionesResponseDto getEvaluacionesById(Integer idEvaluacion) {
        try {
            Evaluaciones evaluacion = this.getEvaluacion(idEvaluacion);
            Optional<Parametros> rto = this.parametrosRepository.findByIdtablaAndValor("MEDIDARTO", String.valueOf(evaluacion.getMedidaRto()));
            int medidaRto = evaluacion.getMedidaRto();
            if (rto == null) {
                throw new Exception("El par\u00e1metro MEDIARTO no es existe valor no encontrado: " + String.valueOf(evaluacion.getMedidaRto()));
            }
            String deMedidaRto = rto.get().getNombre();
            Optional<Parametros> procesoRequeri = this.parametrosRepository.findByIdtablaAndValor("PROCESOREQUERIDO", String.valueOf(evaluacion.getProcesoRequerido()));
            int procesoRequerido = evaluacion.getProcesoRequerido();
            if (procesoRequeri == null) {
                throw new Exception("El par\u00e1metro PROCESOREQUERIDO no es existe valor no encontrado: " + String.valueOf(evaluacion.getProcesoRequerido()));
            }
            String deProcesoRequerido = procesoRequeri.get().getNombre();
            Optional<Parametros> estado = this.parametrosRepository.findByIdtablaAndValor("ESTADO", String.valueOf(evaluacion.getEstado()));
            int estad = evaluacion.getEstado();
            if (estad == 0) {
                throw new Exception("El par\u00e1metro ESTADO no es existe valor no encontrado: " + String.valueOf(evaluacion.getEstado()));
            }
            String deEstado = estado.get().getNombre();
            int rto2 = 0;
            if (evaluacion.getMedidaRto() == 1) {
                rto2 = evaluacion.getRto() / 60 / 24;
            }
            if (evaluacion.getMedidaRto() == 2) {
                rto2 = evaluacion.getRto() / 60;
            }
            if (evaluacion.getMedidaRto() == 3) {
                rto2 = evaluacion.getRto();
            }
            DetalleEvaluacionesResponseDto detalleEvaluacionesResponseDto = new DetalleEvaluacionesResponseDto(evaluacion.getIdEvaluacion(), evaluacion.getIdMaestroEvaluacion().getIdMaestroEvaluacion(), evaluacion.getIdMaestroEvaluacion().getNombreEvaluacion(), evaluacion.getUnidad().getIdUnidad(), evaluacion.getUnidad().getCdUnidad(), evaluacion.getUnidad().getNombre(), evaluacion.getLineaoperacion().getId_lineaoperacion(), evaluacion.getLineaoperacion().getNombre(), evaluacion.getProceso().getId_procesamiento(), evaluacion.getProceso().getIdProceso(), evaluacion.getProceso().getNombre(), rto2, evaluacion.getMedidaRto(), deMedidaRto, evaluacion.getEstado(), deEstado, evaluacion.getPromFact(), evaluacion.getProcesoRequerido(), evaluacion.getMcbo(), evaluacion.getFechaEvalua(), evaluacion.getUsuario(), evaluacion.getFechaRegistro(), evaluacion.getFechaModificacion(), evaluacion.getFactor());
            return detalleEvaluacionesResponseDto;
        }
        catch (DataAccessException ex) {
            this.logger.error(ex.getMessage());
            return null;
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
            return null;
        }
    }

    @Override
    public Evaluaciones getEvaluacion(Integer idEvaluacion) {
        Evaluaciones evaluaciones = (Evaluaciones)this.evaluacionesRepository.findById(idEvaluacion).orElseThrow(() -> new IllegalArgumentException("No se encuentra la evaluaci\u00f3n con id: " + idEvaluacion));
        return evaluaciones;
    }

    @Override
    public Evaluaciones cerrarEvaluaciones(EvaluacionesRequestDto evaluacionesRequestDto, Integer idEvaluacion) {
        Evaluaciones evaluacion = this.getEvaluacion(idEvaluacion);
        if (evaluacion.getEstado() == 1) {
            evaluacion.setEstado(2);
        } else {
            evaluacion.setEstado(1);
        }
        return (Evaluaciones)this.evaluacionesRepository.save(evaluacion);
    }

    @Override
    public Evaluaciones editEvaluaciones(DetalleEvaluacionesRequestDto evaluacionesRequestDto, Integer idEvaluacion) {
        Evaluaciones evaluaciones = this.getEvaluacion(idEvaluacion);
        Maestroevaluacion evaluac = new Maestroevaluacion();
        Optional evaluac2 = this.maestroEvaluacionesRepository.findById(evaluacionesRequestDto.getIdMaestroEvaluacion());
        evaluaciones.setIdMaestroEvaluacion((Maestroevaluacion)evaluac2.get());
        LineaOperacion linea = new LineaOperacion();
        Optional<LineaOperacion> linea2 = this.lineaOperacionRepository.findById(evaluacionesRequestDto.getId_lineaoperacion());
        evaluaciones.setLineaoperacion(linea2.get());
        Unidad unidad = new Unidad();
        Optional<Unidad> unidad2 = this.unidadRepository.findById(evaluacionesRequestDto.getIdUnidad());
        evaluaciones.setUnidad(unidad2.get());
        Proceso proceso = new Proceso();
        Optional proceso2 = this.procesoRepository.findById(evaluacionesRequestDto.getId_procesamiento());
        evaluaciones.setProceso((Proceso)proceso2.get());
        int rto2 = 0;
        if (evaluacionesRequestDto.getMedidaRto() == 1) {
            rto2 = evaluacionesRequestDto.getRto() * 60 * 24;
        }
        if (evaluacionesRequestDto.getMedidaRto() == 2) {
            rto2 = evaluacionesRequestDto.getRto() * 60;
        }
        if (evaluacionesRequestDto.getMedidaRto() == 3) {
            rto2 = evaluacionesRequestDto.getRto();
        }
        evaluaciones.setRto(rto2);
        evaluaciones.setMedidaRto(evaluacionesRequestDto.getMedidaRto());
        evaluaciones.setEstado(1);
        evaluaciones.setPromFact(evaluacionesRequestDto.getPromFact());
        evaluaciones.setMcbo(evaluacionesRequestDto.getMcbo());
        evaluaciones.setProcesoRequerido(evaluacionesRequestDto.getProcesoRequerido());
        evaluaciones.setFechaEvalua(evaluacionesRequestDto.getFechaEvalua());
        evaluaciones.setFechaModificacion(evaluacionesRequestDto.getFechaModificacion());
        evaluaciones.setFechaRegistro(evaluacionesRequestDto.getFechaRegistro());
        evaluaciones.setUsuario(evaluacionesRequestDto.getUsuario());
        evaluaciones.setFactor(evaluacionesRequestDto.getFactores());
        return (Evaluaciones)this.evaluacionesRepository.save(evaluaciones);
    }

    @Override
    public long countEvaluaciones() {
        return this.evaluacionesRepository.count();
    }

    @Override
    public long countEvaluacionesAbiertas(Integer idUnidad) {
        return this.evaluacionesRepository.findEvaluacionesByUnidadAbiertas(idUnidad);
    }

    @Override
    public boolean validarUltimaEvaluacionAbierta(Integer idEvaluacion, Integer idUnidad) {
        Optional<Evaluaciones> evaluacionMaximo = this.evaluacionesRepository.findByEvaluacionesWithMaxIdEvaluacion(idUnidad);
        return idEvaluacion != evaluacionMaximo.get().getIdEvaluacion();
    }
}

