/*
 * Decompiled with CFR 0.152.
 */
package com.dacrt.SBIABackend.service;

import com.dacrt.SBIABackend.dto.DetalleCargosDto;
import com.dacrt.SBIABackend.dto.responseDto.DetalleCargoResponseDto;
import com.dacrt.SBIABackend.entity.Cargos;
import com.dacrt.SBIABackend.entity.Parametros;
import com.dacrt.SBIABackend.repository.CargosRepository;
import com.dacrt.SBIABackend.repository.ParametrosRepository;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.transaction.Transactional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@Transactional
public class CargosService {
    @Autowired
    CargosRepository cargosRepository;
    @Autowired
    ParametrosRepository parametrosRepository;

    public List<DetalleCargosDto> list() {
        ArrayList<DetalleCargosDto> listaCargos = new ArrayList<DetalleCargosDto>();
        String boton = "";
        List cargos = StreamSupport.stream(this.cargosRepository.findAll().spliterator(), false).collect(Collectors.toList());
        for (Cargos cargo : cargos) {
            Optional<Parametros> deEstatus = this.parametrosRepository.findByIdtablaAndValor("ESTATUS", String.valueOf(cargo.getActivo()));
            int id_estatus = Integer.parseInt(deEstatus.get().getValor());
            String estatus = deEstatus.get().getNombre();
            boton = id_estatus == 1 ? "Desactivar" : "Activar";
            DetalleCargosDto detalleCargo = new DetalleCargosDto(cargo.getId_cargos(), cargo.getNombre(), cargo.getDescripcion(), id_estatus, estatus, cargo.getUsuario(), boton, cargo.getFechaRegistro(), cargo.getFechaModificacion());
            listaCargos.add(detalleCargo);
        }
        return listaCargos;
    }

    public DetalleCargoResponseDto getCargosById(Integer id_cargos) {
        String boton = "";
        Cargos cargo = this.getCargo(id_cargos);
        Optional<Parametros> deEstatus = this.parametrosRepository.findByIdtablaAndValor("ESTATUS", String.valueOf(cargo.getActivo()));
        int id_estatus = Integer.parseInt(deEstatus.get().getValor());
        boton = id_estatus == 1 ? "Desactivar" : "Activar";
        String estatus = deEstatus.get().getNombre();
        DetalleCargoResponseDto detalleCargoResponseDto = new DetalleCargoResponseDto(cargo.getId_cargos(), cargo.getNombre(), cargo.getDescripcion(), id_estatus, estatus, boton, cargo.getUsuario(), cargo.getFechaRegistro(), cargo.getFechaModificacion());
        return detalleCargoResponseDto;
    }

    public Cargos getCargo(Integer id_cargos) {
        Cargos cargo = (Cargos)this.cargosRepository.findById(id_cargos).orElseThrow(() -> new IllegalArgumentException("No se encuentra cargo con id: " + id_cargos));
        return cargo;
    }

    public Optional<Cargos> getOne(Integer id_cargos) {
        return this.cargosRepository.findById(id_cargos);
    }

    public Optional<Cargos> getByNombre(String nombre) {
        return this.cargosRepository.findByNombre(nombre);
    }

    public void save(Cargos cargos) {
        this.cargosRepository.save(cargos);
    }

    public void delete(Integer id_cargos) {
        this.cargosRepository.deleteById(id_cargos);
    }

    public boolean existsById(Integer id_cargos) {
        return this.cargosRepository.existsById(id_cargos);
    }

    public boolean existsByNombre(String nombre) {
        return this.cargosRepository.existsByNombre(nombre);
    }
}

