/*
 * Decompiled with CFR 0.152.
 */
package com.dacrt.SBIABackend.service;

import com.dacrt.SBIABackend.dto.Mapper;
import com.dacrt.SBIABackend.dto.requestDto.CanalRequestDto;
import com.dacrt.SBIABackend.dto.responseDto.CanalResponseDto;
import com.dacrt.SBIABackend.dto.responseDto.DetalleCanalResponseDto;
import com.dacrt.SBIABackend.entity.Canal;
import com.dacrt.SBIABackend.entity.Parametros;
import com.dacrt.SBIABackend.repository.CanalRepository;
import com.dacrt.SBIABackend.repository.ParametrosRepository;
import com.dacrt.SBIABackend.service.CanalService;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.transaction.Transactional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@Transactional
public class CanalServiceImpl
implements CanalService {
    @Autowired
    private CanalRepository canalRepository;
    @Autowired
    private ParametrosRepository parametrosRepository;
    Date fechaActual = new Date();

    @Autowired
    public CanalServiceImpl(CanalRepository canalRepository) {
        this.canalRepository = canalRepository;
    }

    @Override
    @Transactional
    public CanalResponseDto addCanal(CanalRequestDto canalRequestDto) {
        Canal canal = new Canal();
        canal.setNombre(canalRequestDto.getNombre());
        canal.setDescripcion(canalRequestDto.getDescripcion());
        canal.setTipoCanal(canalRequestDto.getTipoCanal());
        canal.setActivo(canalRequestDto.getActivo());
        canal.setUsuario(canalRequestDto.getUsuario());
        canal.setFechaRegistro(canalRequestDto.getFechaRegistro());
        canal.setFechaModificacion(canalRequestDto.getFechaModificacion());
        return Mapper.canaltoCanalResponseDto((Canal)this.canalRepository.save(canal));
    }

    @Override
    public DetalleCanalResponseDto getCanalById(Integer id_canal) {
        String boton = "";
        Canal canal = this.getCanal(id_canal);
        Optional<Parametros> deEstatus = this.parametrosRepository.findByIdtablaAndValor("ESTATUS", String.valueOf(canal.getActivo()));
        Optional<Parametros> deTipoCanal = this.parametrosRepository.findByIdtablaAndValor("TIPOCANAL", String.valueOf(canal.getTipoCanal()));
        int id_estatus = Integer.parseInt(deEstatus.get().getValor());
        boton = id_estatus == 1 ? "Desactivar" : "Activar";
        String estatus = deEstatus.get().getNombre();
        int id_tipocanal = Integer.parseInt(deTipoCanal.get().getValor());
        String tipoCanal = deTipoCanal.get().getNombre();
        DetalleCanalResponseDto detalleCanalResponseDto = new DetalleCanalResponseDto(canal.getId_canal(), canal.getNombre(), canal.getDescripcion(), id_tipocanal, tipoCanal, id_estatus, estatus, boton, canal.getUsuario(), canal.getFechaRegistro(), canal.getFechaModificacion());
        return detalleCanalResponseDto;
    }

    @Override
    public Canal getCanal(Integer id_canal) {
        Canal canal = (Canal)this.canalRepository.findById(id_canal).orElseThrow(() -> new IllegalArgumentException("No se encuentra canal con id: " + id_canal));
        return canal;
    }

    @Override
    public List<DetalleCanalResponseDto> getCanales() {
        ArrayList<DetalleCanalResponseDto> listaDetalleCanales = new ArrayList<DetalleCanalResponseDto>();
        List canales = StreamSupport.stream(this.canalRepository.findAll().spliterator(), false).collect(Collectors.toList());
        for (Canal canal : canales) {
            Optional<Parametros> deEstatus = this.parametrosRepository.findByIdtablaAndValor("ESTATUS", String.valueOf(canal.getActivo()));
            Optional<Parametros> deTipoCanal = this.parametrosRepository.findByIdtablaAndValor("TIPOCANAL", String.valueOf(canal.getTipoCanal()));
            int id_estatus = Integer.parseInt(deEstatus.get().getValor());
            String boton = id_estatus == 1 ? "Desactivar" : "Activar";
            String estatus = deEstatus.get().getNombre();
            int id_tipocanal = Integer.parseInt(deTipoCanal.get().getValor());
            String tipoCanal = deTipoCanal.get().getNombre();
            DetalleCanalResponseDto detalleCanal = new DetalleCanalResponseDto(canal.getId_canal(), canal.getNombre(), canal.getDescripcion(), id_tipocanal, tipoCanal, id_estatus, estatus, boton, canal.getUsuario(), canal.getFechaRegistro(), canal.getFechaModificacion());
            listaDetalleCanales.add(detalleCanal);
        }
        return listaDetalleCanales;
    }

    @Override
    public CanalResponseDto deleteCanal(Integer id_canal, CanalRequestDto canalRequestDto) {
        Canal canal = this.getCanal(id_canal);
        Integer inactivo = 2;
        canal.setNombre(canalRequestDto.getNombre());
        canal.setDescripcion(canalRequestDto.getDescripcion());
        canal.setTipoCanal(canalRequestDto.getTipoCanal());
        canal.setActivo(inactivo);
        canal.setUsuario(canalRequestDto.getUsuario());
        canal.setFechaRegistro(canalRequestDto.getFechaRegistro());
        canal.setFechaModificacion(this.fechaActual);
        return Mapper.canaltoCanalResponseDto((Canal)this.canalRepository.save(canal));
    }

    @Override
    public CanalResponseDto editCanal(Integer id_canal, CanalRequestDto canalRequestDto) {
        Canal canalToEdit = this.getCanal(id_canal);
        canalToEdit.setNombre(canalRequestDto.getNombre());
        canalToEdit.setDescripcion(canalRequestDto.getDescripcion());
        canalToEdit.setActivo(canalRequestDto.getActivo());
        canalToEdit.setFechaModificacion(this.fechaActual);
        canalToEdit.setTipoCanal(canalRequestDto.getTipoCanal());
        canalToEdit.setUsuario(canalRequestDto.getUsuario());
        return Mapper.canaltoCanalResponseDto((Canal)this.canalRepository.save(canalToEdit));
    }

    @Override
    public Optional<Canal> findByNombre(CanalRequestDto canalRequestDto) {
        return this.canalRepository.findByNombre(canalRequestDto.getNombre());
    }

    @Override
    public boolean existsByNombre(CanalRequestDto canalRequestDto) {
        return this.canalRepository.existsByNombre(canalRequestDto.getNombre());
    }

    @Override
    public boolean existsByNombre(String nombre) {
        return this.canalRepository.existsByNombre(nombre);
    }

    @Override
    public boolean existsById(Integer id_canal) {
        return this.canalRepository.existsById(id_canal);
    }

    @Override
    public Optional<Canal> getByNombre(String nombre) {
        return this.canalRepository.findByNombre(nombre);
    }

    @Override
    public Optional<Canal> getOne(int id_canal) {
        return this.canalRepository.findById(id_canal);
    }

    @Override
    public void save(Canal canal) {
        this.canalRepository.save(canal);
    }
}

