/*
 * Decompiled with CFR 0.152.
 */
package com.dacrt.SBIABackend.controler;

import com.dacrt.SBIABackend.dto.Mensaje;
import com.dacrt.SBIABackend.dto.requestDto.DetalleUnidadRequestDto;
import com.dacrt.SBIABackend.dto.requestDto.UnidadRequestDto;
import com.dacrt.SBIABackend.dto.responseDto.DetalleUnidadResponseDto;
import com.dacrt.SBIABackend.dto.responseDto.UnidadResponseDto;
import com.dacrt.SBIABackend.entity.Parametros;
import com.dacrt.SBIABackend.entity.Unidad;
import com.dacrt.SBIABackend.entity.UnidadAdscripcion;
import com.dacrt.SBIABackend.service.ParametrosService;
import com.dacrt.SBIABackend.service.UnidadAdscripcionService;
import com.dacrt.SBIABackend.service.UnidadService;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/unidades"})
@CrossOrigin(origins={"*"})
public class UnidadControler {
    private final UnidadService unidadService;
    private final UnidadAdscripcionService unidadAdscripcionService;
    private final ParametrosService parametrosService;
    Logger logger = LoggerFactory.getLogger(UnidadControler.class);
    Date fechaActual = new Date();

    @Autowired
    public UnidadControler(UnidadService unidadService, UnidadAdscripcionService unidadAdscripcionService, ParametrosService parametrosService) {
        this.unidadService = unidadService;
        this.parametrosService = parametrosService;
        this.unidadAdscripcionService = unidadAdscripcionService;
    }

    @GetMapping(value={"/detail/{idUnidad}"})
    public ResponseEntity<DetalleUnidadResponseDto> getUnidad(@PathVariable Integer idUnidad) {
        if (!this.unidadService.existsById(idUnidad)) {
            return new ResponseEntity((Object)new Mensaje("No existe el id " + idUnidad + " de unidad solicitado"), HttpStatus.NOT_FOUND);
        }
        DetalleUnidadResponseDto unidadResponseDto = this.unidadService.getUnidadById(idUnidad);
        return new ResponseEntity((Object)unidadResponseDto, HttpStatus.OK);
    }

    @GetMapping(value={"/cantidadProcesos/{idUnidad}"})
    public ResponseEntity<?> countProcesosPorUnidad(@PathVariable Integer idUnidad) {
        long cantidadProcesos = this.unidadService.countProcesosPorUnidad(idUnidad);
        return new ResponseEntity((Object)cantidadProcesos, HttpStatus.OK);
    }

    @GetMapping(value={"/lista"})
    public ResponseEntity<List<DetalleUnidadResponseDto>> getUnidades() {
        List<DetalleUnidadResponseDto> unidadResponseDtos = this.unidadService.getUnidades();
        return new ResponseEntity(unidadResponseDtos, HttpStatus.OK);
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @PostMapping(value={"/create"})
    public ResponseEntity<UnidadResponseDto> addUnidad(@RequestBody UnidadRequestDto unidadRequestDto) {
        try {
            if (StringUtils.isBlank((CharSequence)unidadRequestDto.getCdUnidad()) || StringUtils.isBlank((CharSequence)unidadRequestDto.getNombre()) || StringUtils.isBlank((CharSequence)unidadRequestDto.getDescripcion()) || unidadRequestDto.getActivo() == 0 || unidadRequestDto.getTipoClasificacion() == 0 || unidadRequestDto.getIdUnidadAdscripcion() == 0 || unidadRequestDto.getProcesos().isEmpty()) {
                return new ResponseEntity((Object)new Mensaje("Los campos son obligatorios"), HttpStatus.BAD_REQUEST);
            }
            if (unidadRequestDto.getCdUnidad().length() > 6 || unidadRequestDto.getNombre().length() > 200 || unidadRequestDto.getDescripcion().length() > 400 || String.valueOf(unidadRequestDto.getActivo()).length() > 1 || String.valueOf(unidadRequestDto.getTipoClasificacion()).length() > 1) {
                return new ResponseEntity((Object)new Mensaje("Varifique el tama\u00f1o del contenido de los campos"), HttpStatus.BAD_REQUEST);
            }
            if (this.unidadService.existsByCdUnidad(unidadRequestDto.getCdUnidad())) {
                return new ResponseEntity((Object)new Mensaje("Ya se encuentra registrado el c\u00f3digo de la Unidad"), HttpStatus.BAD_REQUEST);
            }
            if (this.unidadService.existsByNombre(unidadRequestDto)) {
                return new ResponseEntity((Object)new Mensaje("Ya se encuentra registrado el nombre de la Unidad"), HttpStatus.BAD_REQUEST);
            }
            Optional<Parametros> deEstatus = this.parametrosService.getByIdtablaAndValor("ESTATUS", String.valueOf(unidadRequestDto.getActivo()));
            if (!deEstatus.isPresent()) {
                return new ResponseEntity((Object)new Mensaje("El tipo de estatus no existe"), HttpStatus.BAD_REQUEST);
            }
            String valor = deEstatus.get().getValor();
            Optional<Parametros> deTipoClasificacion = this.parametrosService.getByIdtablaAndValor("TIPOCLASIFICACION", String.valueOf(unidadRequestDto.getTipoClasificacion()));
            if (!deTipoClasificacion.isPresent()) {
                return new ResponseEntity((Object)new Mensaje("El tipo de clasficaci\u00f3n no existe"), HttpStatus.BAD_REQUEST);
            }
            String valor2 = deTipoClasificacion.get().getValor();
            if (unidadRequestDto.getIdUnidadAdscripcion() == 0) {
                unidadRequestDto.setUnidadAdscripcion(null);
            }
            unidadRequestDto.setProcesos(unidadRequestDto.getProcesos());
            UnidadResponseDto unidadResponseDto = this.unidadService.addUnidad(unidadRequestDto);
            return new ResponseEntity((Object)unidadResponseDto, HttpStatus.OK);
        }
        catch (DataAccessException ex) {
            this.logger.error(ex.getMessage());
            return new ResponseEntity((Object)new Mensaje(ex.getMessage()), HttpStatus.METHOD_NOT_ALLOWED);
        }
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @PutMapping(value={"/update/{idUnidad}"})
    public ResponseEntity<DetalleUnidadResponseDto> editUnidad(@RequestBody DetalleUnidadRequestDto detalleUnidadRequestDto, @PathVariable(value="idUnidad") Integer idUnidad) {
        try {
            if (!this.unidadService.existsById(idUnidad)) {
                return new ResponseEntity((Object)new Mensaje("No existe el id de unidad solicitado"), HttpStatus.NOT_FOUND);
            }
            if (StringUtils.isBlank((CharSequence)detalleUnidadRequestDto.getCdUnidad()) || StringUtils.isBlank((CharSequence)detalleUnidadRequestDto.getNombre()) || StringUtils.isBlank((CharSequence)detalleUnidadRequestDto.getDescripcion()) || detalleUnidadRequestDto.getActivo() == 0 || detalleUnidadRequestDto.getTipoClasificacion() == 0 || detalleUnidadRequestDto.getIdUnidadAdscripcion() == 0) {
                return new ResponseEntity((Object)new Mensaje("Los campos son obligatorios"), HttpStatus.BAD_REQUEST);
            }
            if (detalleUnidadRequestDto.getCdUnidad().length() > 6 || detalleUnidadRequestDto.getNombre().length() > 200 || detalleUnidadRequestDto.getDescripcion().length() > 400 || String.valueOf(detalleUnidadRequestDto.getActivo()).length() > 1 || String.valueOf(detalleUnidadRequestDto.getTipoClasificacion()).length() > 1 || String.valueOf(detalleUnidadRequestDto.getIdUnidadAdscripcion()).length() > 1) {
                return new ResponseEntity((Object)new Mensaje("Verifique el tama\u00f1o del contenido de los campos"), HttpStatus.BAD_REQUEST);
            }
            if (this.unidadService.existsByNombre(detalleUnidadRequestDto.getNombre()) && this.unidadService.getByNombre(detalleUnidadRequestDto.getNombre()).get().getIdUnidad() != idUnidad.intValue()) {
                return new ResponseEntity((Object)new Mensaje("El nombre de la unidad " + detalleUnidadRequestDto.getNombre() + " ya existe"), HttpStatus.BAD_REQUEST);
            }
            if (this.unidadService.existsByCdUnidad(detalleUnidadRequestDto.getCdUnidad()) && this.unidadService.getByCdUnidad(detalleUnidadRequestDto.getCdUnidad()).get().getIdUnidad() != idUnidad.intValue()) {
                return new ResponseEntity((Object)new Mensaje("El c\u00f3digo de la unidad " + detalleUnidadRequestDto.getCdUnidad() + " ya existe y es id " + this.unidadService.getByCdUnidad(detalleUnidadRequestDto.getCdUnidad()).get().getIdUnidad()), HttpStatus.BAD_REQUEST);
            }
            Unidad unidad = this.unidadService.getOne(idUnidad).get();
            unidad.setCdUnidad(detalleUnidadRequestDto.getCdUnidad());
            unidad.setNombre(detalleUnidadRequestDto.getNombre());
            unidad.setDescripcion(detalleUnidadRequestDto.getDescripcion());
            unidad.setActivo(detalleUnidadRequestDto.getActivo());
            unidad.setTipoClasificacion(detalleUnidadRequestDto.getTipoClasificacion());
            unidad.setFechaModificacion(this.fechaActual);
            unidad.setUsuario(detalleUnidadRequestDto.getUsuario());
            unidad.setFechaRegistro(detalleUnidadRequestDto.getFechaRegistro());
            if (detalleUnidadRequestDto.getIdUnidadAdscripcion() != 0) {
                UnidadAdscripcion unidadAdscripcion = this.unidadAdscripcionService.getUnidadAdscripcion(detalleUnidadRequestDto.getIdUnidadAdscripcion());
                unidad.setUnidadAdscripcion(unidadAdscripcion);
            } else {
                unidad.setUnidadAdscripcion(null);
            }
            unidad.getProcesos().removeAll(unidad.getProcesos());
            unidad.getProcesos().addAll(detalleUnidadRequestDto.getProcesos());
            this.unidadService.save(unidad);
            return new ResponseEntity((Object)new Mensaje("Unidad actualizada"), HttpStatus.OK);
        }
        catch (DataAccessException ex) {
            this.logger.error(ex.getMessage());
            return new ResponseEntity((Object)new Mensaje(ex.getMessage()), HttpStatus.METHOD_NOT_ALLOWED);
        }
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @PutMapping(value={"/delete/{idUnidad}"})
    public ResponseEntity<?> deleteUnidad(@RequestBody DetalleUnidadRequestDto detalleUnidadRequestDto, @PathVariable(value="idUnidad") Integer idUnidad) {
        try {
            if (!this.unidadService.existsById(idUnidad)) {
                return new ResponseEntity((Object)new Mensaje("No existe el id de la unidad solicitada"), HttpStatus.NOT_FOUND);
            }
            Unidad unidad = this.unidadService.getOne(idUnidad).get();
            int valor = unidad.getActivo() == 1 ? 2 : 1;
            unidad.setActivo(valor);
            unidad.setFechaModificacion(this.fechaActual);
            unidad.setUsuario(detalleUnidadRequestDto.getUsuario());
            this.unidadService.save(unidad);
            return new ResponseEntity((Object)new Mensaje("Estatus de la Unidad actualizada"), HttpStatus.OK);
        }
        catch (DataAccessException ex) {
            this.logger.error(ex.getMessage());
            return new ResponseEntity((Object)new Mensaje(ex.getMessage()), HttpStatus.METHOD_NOT_ALLOWED);
        }
    }
}

