/*
 * Decompiled with CFR 0.152.
 */
package com.dacrt.SBIABackend.controler;

import com.dacrt.SBIABackend.dto.Mensaje;
import com.dacrt.SBIABackend.dto.requestDto.DetalleUnidadAdscripcionRequestDto;
import com.dacrt.SBIABackend.dto.requestDto.UnidadAdscripcionRequestDto;
import com.dacrt.SBIABackend.dto.responseDto.DetalleUnidadAdscripcionResponseDto;
import com.dacrt.SBIABackend.dto.responseDto.UnidadAdscripcionResponseDto;
import com.dacrt.SBIABackend.entity.Parametros;
import com.dacrt.SBIABackend.entity.UnidadAdscripcion;
import com.dacrt.SBIABackend.service.ParametrosService;
import com.dacrt.SBIABackend.service.UnidadAdscripcionService;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/unidadesAdscripcion"})
@CrossOrigin(origins={"*"})
public class UnidadAdscripcionControler {
    private final UnidadAdscripcionService unidadAdscripcionService;
    private final ParametrosService parametrosService;
    Logger logger = LoggerFactory.getLogger(UnidadAdscripcionControler.class);
    Date fechaActual = new Date();

    @Autowired
    public UnidadAdscripcionControler(UnidadAdscripcionService unidadAdscripcionService, ParametrosService parametrosService) {
        this.unidadAdscripcionService = unidadAdscripcionService;
        this.parametrosService = parametrosService;
    }

    @GetMapping(value={"/detail/{idUnidadAdscripcion}"})
    public ResponseEntity<DetalleUnidadAdscripcionResponseDto> getUnidadAdscripcion(@PathVariable Integer idUnidadAdscripcion) {
        if (!this.unidadAdscripcionService.existsById(idUnidadAdscripcion)) {
            return new ResponseEntity((Object)new Mensaje("No existe el id " + idUnidadAdscripcion + " de unidad de adscripcion solicitado"), HttpStatus.NOT_FOUND);
        }
        DetalleUnidadAdscripcionResponseDto unidadAdscripcionResponseDto = this.unidadAdscripcionService.getUnidadAdscripcionById(idUnidadAdscripcion);
        return new ResponseEntity((Object)unidadAdscripcionResponseDto, HttpStatus.OK);
    }

    @GetMapping(value={"/lista"})
    public ResponseEntity<List<DetalleUnidadAdscripcionResponseDto>> getUnidadesAdscripciones() {
        List<DetalleUnidadAdscripcionResponseDto> unidadAdscripcionResponseDtos = this.unidadAdscripcionService.getUnidadesAdscripcion();
        return new ResponseEntity(unidadAdscripcionResponseDtos, HttpStatus.OK);
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @PostMapping(value={"/create"})
    public ResponseEntity<UnidadAdscripcionResponseDto> addUnidadAdscripcion(@RequestBody UnidadAdscripcionRequestDto unidadAdscripcionRequestDto) {
        try {
            if (StringUtils.isBlank((CharSequence)unidadAdscripcionRequestDto.getCdUnidad()) || StringUtils.isBlank((CharSequence)unidadAdscripcionRequestDto.getNombre()) || StringUtils.isBlank((CharSequence)unidadAdscripcionRequestDto.getDescripcion()) || unidadAdscripcionRequestDto.getActivo() == 0 || unidadAdscripcionRequestDto.getTipoClasificacion() == 0) {
                return new ResponseEntity((Object)new Mensaje("Los campos son obligatorios"), HttpStatus.BAD_REQUEST);
            }
            if (unidadAdscripcionRequestDto.getCdUnidad().length() > 6 || unidadAdscripcionRequestDto.getNombre().length() > 200 || unidadAdscripcionRequestDto.getDescripcion().length() > 400 || String.valueOf(unidadAdscripcionRequestDto.getActivo()).length() > 1 || String.valueOf(unidadAdscripcionRequestDto.getTipoClasificacion()).length() > 1) {
                return new ResponseEntity((Object)new Mensaje("Varifique el tama\u00f1o del contenido de los campos"), HttpStatus.BAD_REQUEST);
            }
            if (this.unidadAdscripcionService.existsByCdUnidad(unidadAdscripcionRequestDto.getCdUnidad())) {
                return new ResponseEntity((Object)new Mensaje("Ya se encuentra registrado el c\u00f3digo de la Unidad de Adscripci\u00f3n"), HttpStatus.BAD_REQUEST);
            }
            if (this.unidadAdscripcionService.existsByNombre(unidadAdscripcionRequestDto)) {
                return new ResponseEntity((Object)new Mensaje("Ya se encuentra registrado el nombre de la Unidad de Adscripci\u00f3n"), HttpStatus.BAD_REQUEST);
            }
            Optional<Parametros> deEstatus = this.parametrosService.getByIdtablaAndValor("ESTATUS", String.valueOf(unidadAdscripcionRequestDto.getActivo()));
            if (!deEstatus.isPresent()) {
                return new ResponseEntity((Object)new Mensaje("El tipo de estatus no existe"), HttpStatus.BAD_REQUEST);
            }
            String valor = deEstatus.get().getValor();
            Optional<Parametros> deTipoClasificacion = this.parametrosService.getByIdtablaAndValor("TIPOCLASIFICACION", String.valueOf(unidadAdscripcionRequestDto.getTipoClasificacion()));
            if (!deTipoClasificacion.isPresent()) {
                return new ResponseEntity((Object)new Mensaje("El tipo de clasficaci\u00f3n no existe"), HttpStatus.BAD_REQUEST);
            }
            String valor2 = deTipoClasificacion.get().getValor();
            UnidadAdscripcionResponseDto unidadAdscripcionResponseDto = this.unidadAdscripcionService.addUnidadAdscripcion(unidadAdscripcionRequestDto);
            return new ResponseEntity((Object)unidadAdscripcionResponseDto, HttpStatus.OK);
        }
        catch (DataAccessException ex) {
            this.logger.error(ex.getMessage());
            return new ResponseEntity((Object)new Mensaje(ex.getMessage()), HttpStatus.METHOD_NOT_ALLOWED);
        }
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @PutMapping(value={"/update/{idUnidadAdscripcion}"})
    public ResponseEntity<DetalleUnidadAdscripcionResponseDto> editUnidadAdscripcion(@RequestBody DetalleUnidadAdscripcionRequestDto detalleUnidadAdscripcionRequestDto, @PathVariable(value="idUnidadAdscripcion") Integer idUnidadAdscripcion) {
        try {
            if (!this.unidadAdscripcionService.existsById(idUnidadAdscripcion)) {
                return new ResponseEntity((Object)new Mensaje("No existe el id de unidad de adscripci\u00f3n solicitado"), HttpStatus.NOT_FOUND);
            }
            if (StringUtils.isBlank((CharSequence)detalleUnidadAdscripcionRequestDto.getCdUnidad()) || StringUtils.isBlank((CharSequence)detalleUnidadAdscripcionRequestDto.getNombre()) || StringUtils.isBlank((CharSequence)detalleUnidadAdscripcionRequestDto.getDescripcion()) || detalleUnidadAdscripcionRequestDto.getActivo() == 0 || detalleUnidadAdscripcionRequestDto.getTipoClasificacion() == 0) {
                return new ResponseEntity((Object)new Mensaje("Los campos son obligatorios"), HttpStatus.BAD_REQUEST);
            }
            if (detalleUnidadAdscripcionRequestDto.getCdUnidad().length() > 6 || detalleUnidadAdscripcionRequestDto.getNombre().length() > 200 || detalleUnidadAdscripcionRequestDto.getDescripcion().length() > 400 || String.valueOf(detalleUnidadAdscripcionRequestDto.getActivo()).length() > 1 || String.valueOf(detalleUnidadAdscripcionRequestDto.getTipoClasificacion()).length() > 1) {
                return new ResponseEntity((Object)new Mensaje("Verifique el tama\u00f1o del contenido de los campos"), HttpStatus.BAD_REQUEST);
            }
            if (this.unidadAdscripcionService.existsByNombre(detalleUnidadAdscripcionRequestDto) && this.unidadAdscripcionService.getByNombre(detalleUnidadAdscripcionRequestDto.getNombre()).get().getIdUnidadAdscripcion() != idUnidadAdscripcion.intValue()) {
                return new ResponseEntity((Object)new Mensaje("El nombre de la unidad de adscripci\u00f3n" + detalleUnidadAdscripcionRequestDto.getNombre() + " ya existe"), HttpStatus.BAD_REQUEST);
            }
            if (this.unidadAdscripcionService.existsByCdUnidad(detalleUnidadAdscripcionRequestDto.getCdUnidad()) && this.unidadAdscripcionService.getByCdUnidad(detalleUnidadAdscripcionRequestDto.getCdUnidad()).get().getIdUnidadAdscripcion() != idUnidadAdscripcion.intValue()) {
                return new ResponseEntity((Object)new Mensaje("El c\u00f3digo de la unidad de adscripci\u00f3n" + detalleUnidadAdscripcionRequestDto.getCdUnidad() + " ya existe y es id " + this.unidadAdscripcionService.getByCdUnidad(detalleUnidadAdscripcionRequestDto.getCdUnidad()).get().getIdUnidadAdscripcion()), HttpStatus.BAD_REQUEST);
            }
            UnidadAdscripcion unidadAdscripcion = this.unidadAdscripcionService.getOne(idUnidadAdscripcion).get();
            unidadAdscripcion.setCdUnidad(detalleUnidadAdscripcionRequestDto.getCdUnidad());
            unidadAdscripcion.setNombre(detalleUnidadAdscripcionRequestDto.getNombre());
            unidadAdscripcion.setDescripcion(detalleUnidadAdscripcionRequestDto.getDescripcion());
            unidadAdscripcion.setActivo(detalleUnidadAdscripcionRequestDto.getActivo());
            unidadAdscripcion.setTipoClasificacion(detalleUnidadAdscripcionRequestDto.getTipoClasificacion());
            unidadAdscripcion.setFechaModificacion(detalleUnidadAdscripcionRequestDto.getFechaModificacion());
            unidadAdscripcion.setUsuario(detalleUnidadAdscripcionRequestDto.getUsuario());
            unidadAdscripcion.setFechaRegistro(detalleUnidadAdscripcionRequestDto.getFechaRegistro());
            this.unidadAdscripcionService.save(unidadAdscripcion);
            return new ResponseEntity((Object)new Mensaje("Unidad actualizada"), HttpStatus.OK);
        }
        catch (DataAccessException ex) {
            this.logger.error(ex.getMessage());
            return new ResponseEntity((Object)new Mensaje(ex.getMessage()), HttpStatus.METHOD_NOT_ALLOWED);
        }
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @PutMapping(value={"/delete/{idUnidadAdscripcion}"})
    public ResponseEntity<?> deleteUnidadAdscripcion(UnidadAdscripcionRequestDto unidadAdscripcionRequestDto, @PathVariable(value="idUnidadAdscripcion") Integer idUnidadAdscripcion) {
        try {
            if (!this.unidadAdscripcionService.existsById(idUnidadAdscripcion)) {
                return new ResponseEntity((Object)new Mensaje("No existe el id de la unidad de adscripci\u00f3n solicitada"), HttpStatus.NOT_FOUND);
            }
            UnidadAdscripcion unidadAdscripcion = this.unidadAdscripcionService.getOne(idUnidadAdscripcion).get();
            int valor = unidadAdscripcion.getActivo() == 1 ? 2 : 1;
            unidadAdscripcion.setNombre(unidadAdscripcion.getNombre());
            unidadAdscripcion.setCdUnidad(unidadAdscripcion.getCdUnidad());
            unidadAdscripcion.setTipoClasificacion(unidadAdscripcion.getTipoClasificacion());
            unidadAdscripcion.setActivo(valor);
            unidadAdscripcion.setDescripcion(unidadAdscripcion.getDescripcion());
            unidadAdscripcion.setFechaModificacion(this.fechaActual);
            unidadAdscripcion.setFechaRegistro(unidadAdscripcion.getFechaRegistro());
            unidadAdscripcion.setUsuario(unidadAdscripcion.getUsuario());
            this.unidadAdscripcionService.save(unidadAdscripcion);
            return new ResponseEntity((Object)new Mensaje("Estatus de la Unidad de adscripci\u00f3n actualizada"), HttpStatus.OK);
        }
        catch (DataAccessException ex) {
            this.logger.error(ex.getMessage());
            return new ResponseEntity((Object)new Mensaje(ex.getMessage()), HttpStatus.METHOD_NOT_ALLOWED);
        }
    }
}

