/*
 * Decompiled with CFR 0.152.
 */
package com.dacrt.SBIABackend.controler;

import com.dacrt.SBIABackend.dto.Mensaje;
import com.dacrt.SBIABackend.dto.TipoInsumoDto;
import com.dacrt.SBIABackend.dto.requestDto.DetalleTipoInsumoRequestDto;
import com.dacrt.SBIABackend.dto.responseDto.DetalleTipoInsumoResponseDto;
import com.dacrt.SBIABackend.entity.TipoInsumo;
import com.dacrt.SBIABackend.service.TipoInsumoService;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/tipoinsumo"})
@CrossOrigin(origins={"*"})
public class TipoInsumoControler {
    @Autowired
    TipoInsumoService tipoInsumoService;
    Logger logger = LoggerFactory.getLogger(TipoInsumoControler.class);
    Date fechaActual = new Date();

    @GetMapping(value={"/lista"})
    public ResponseEntity<List<TipoInsumo>> list() {
        List<DetalleTipoInsumoResponseDto> list = this.tipoInsumoService.getTipoInsumos();
        return new ResponseEntity(list, HttpStatus.OK);
    }

    @GetMapping(value={"/detail/{id_tipoinsumo}"})
    public ResponseEntity<DetalleTipoInsumoResponseDto> getById(@PathVariable(value="id_tipoinsumo") Integer id_tipoinsumo) {
        if (!this.tipoInsumoService.existsById(id_tipoinsumo)) {
            this.logger.warn("No existe el Tipo de Insumo: id_tipoinsumo: " + id_tipoinsumo);
            return new ResponseEntity((Object)new Mensaje("No existe el Tipo de Insumo"), HttpStatus.NOT_FOUND);
        }
        DetalleTipoInsumoResponseDto detalleTipoInsumo = this.tipoInsumoService.getTipoInsumoById(id_tipoinsumo);
        return new ResponseEntity((Object)detalleTipoInsumo, HttpStatus.OK);
    }

    @GetMapping(value={"/detailname/{nombre}"})
    public ResponseEntity<TipoInsumo> getByNombre(@PathVariable(value="nombre") String nombre) {
        if (!this.tipoInsumoService.existsByNombre(nombre)) {
            this.logger.warn("No existe el Tipo de Insumo " + nombre + " solicitado ");
            return new ResponseEntity((Object)new Mensaje("No existe el Tipo de Insumo " + nombre + " solicitado "), HttpStatus.NOT_FOUND);
        }
        TipoInsumo tipoInsumo = this.tipoInsumoService.getByNombre(nombre).get();
        return new ResponseEntity((Object)tipoInsumo, HttpStatus.OK);
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @PostMapping(value={"/create"})
    public ResponseEntity<?> create(@RequestBody TipoInsumoDto tipoInsumoDto) {
        try {
            if (StringUtils.isBlank((CharSequence)tipoInsumoDto.getNombre()) || tipoInsumoDto.getActivo() == 0) {
                this.logger.warn("Los campos son obligatorios");
                return new ResponseEntity((Object)new Mensaje("Los campos son obligatorios"), HttpStatus.BAD_REQUEST);
            }
            if (tipoInsumoDto.getNombre().length() > 200 || tipoInsumoDto.getActivo() > 1) {
                this.logger.warn("Verifique la longitud de los campos");
                return new ResponseEntity((Object)new Mensaje("Verifique la longitud de los campos"), HttpStatus.BAD_REQUEST);
            }
            if (this.tipoInsumoService.existsByNombre(tipoInsumoDto.getNombre())) {
                return new ResponseEntity((Object)new Mensaje("El nombre del Tipo de Insumo" + tipoInsumoDto.getNombre() + " ya existe"), HttpStatus.BAD_REQUEST);
            }
            TipoInsumo tipoInsumo = new TipoInsumo();
            tipoInsumo.setNombre(tipoInsumoDto.getNombre());
            tipoInsumo.setActivo(tipoInsumoDto.getActivo());
            tipoInsumo.setUsuario(tipoInsumoDto.getUsuario());
            tipoInsumo.setFechaModificacion(tipoInsumoDto.getFechaModificacion());
            tipoInsumo.setFechaRegistro(tipoInsumoDto.getFechaRegistro());
            TipoInsumo tipoInsumo2 = this.tipoInsumoService.addTipoInsumo(tipoInsumo);
            if (tipoInsumo2 != null) {
                this.logger.warn("Tipo de Insumo" + tipoInsumoDto.getNombre() + " creado");
                return new ResponseEntity((Object)new Mensaje("Tipo de Insumo" + tipoInsumoDto.getNombre() + " creado"), HttpStatus.OK);
            }
            this.logger.warn("Error: Tipo de Insumo" + tipoInsumoDto.getNombre() + " no ha sido creado");
            return new ResponseEntity((Object)new Mensaje("Error: Tipo de Insumo" + tipoInsumoDto.getNombre() + " no ha sido creado"), HttpStatus.OK);
        }
        catch (Exception ex) {
            this.logger.error(ex.getMessage());
            return new ResponseEntity((Object)new Mensaje(ex.getMessage()), HttpStatus.METHOD_NOT_ALLOWED);
        }
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @PutMapping(value={"/update/{id_tipoinsumo}"})
    public ResponseEntity<?> update(@RequestBody DetalleTipoInsumoRequestDto detalleTipoInsumoRequestDto, @PathVariable(value="id_tipoinsumo") Integer id_tipoinsumo) {
        try {
            if (!this.tipoInsumoService.existsById(id_tipoinsumo)) {
                this.logger.warn("No existe el Tipo de Insumo id: " + this.tipoInsumoService.existsById(id_tipoinsumo));
                return new ResponseEntity((Object)new Mensaje("No existe el Tipo de Insumo"), HttpStatus.NOT_FOUND);
            }
            if (StringUtils.isBlank((CharSequence)detalleTipoInsumoRequestDto.getNombre()) || detalleTipoInsumoRequestDto.getActivo() == 0) {
                this.logger.warn("Los campos son obligatorios");
                return new ResponseEntity((Object)new Mensaje("Los campos son obligatorios"), HttpStatus.BAD_REQUEST);
            }
            if (detalleTipoInsumoRequestDto.getNombre().length() > 200 || detalleTipoInsumoRequestDto.getActivo() > 1) {
                this.logger.warn("Verifique la longitud de los campos");
                return new ResponseEntity((Object)new Mensaje("Verifique la longitud de los campos"), HttpStatus.BAD_REQUEST);
            }
            if (this.tipoInsumoService.existsByNombre(detalleTipoInsumoRequestDto.getNombre()) && this.tipoInsumoService.getByNombre(detalleTipoInsumoRequestDto.getNombre()).get().getId_tipoinsumo() != id_tipoinsumo) {
                this.logger.warn("No existe el Tipo de Insumo id: " + this.tipoInsumoService.existsById(id_tipoinsumo));
                return new ResponseEntity((Object)new Mensaje("El nombre del Tipo de Insumo ya existe"), HttpStatus.BAD_REQUEST);
            }
            if (StringUtils.isBlank((CharSequence)detalleTipoInsumoRequestDto.getNombre())) {
                this.logger.warn("No existe el Tipo de Insumo id: " + this.tipoInsumoService.existsById(id_tipoinsumo));
                return new ResponseEntity((Object)new Mensaje("El nombre del Tipo de Insumo es obligatorio"), HttpStatus.BAD_REQUEST);
            }
            TipoInsumo tipoInsumo = this.tipoInsumoService.getTipoInsumo(id_tipoinsumo);
            tipoInsumo.setNombre(detalleTipoInsumoRequestDto.getNombre());
            tipoInsumo.setActivo(detalleTipoInsumoRequestDto.getActivo());
            tipoInsumo.setUsuario(detalleTipoInsumoRequestDto.getUsuario());
            tipoInsumo.setFechaModificacion(detalleTipoInsumoRequestDto.getFechaModificacion());
            tipoInsumo.setFechaRegistro(detalleTipoInsumoRequestDto.getFechaRegistro());
            TipoInsumo tipoInsumo2 = this.tipoInsumoService.addTipoInsumo(tipoInsumo);
            if (tipoInsumo2 != null) {
                this.logger.warn("Tipo de Insumo" + detalleTipoInsumoRequestDto.getNombre() + " actualizado");
                return new ResponseEntity((Object)new Mensaje("Tipo de Insumo" + detalleTipoInsumoRequestDto.getNombre() + " actualizado"), HttpStatus.OK);
            }
            this.logger.warn("Error: Tipo de Insumo" + detalleTipoInsumoRequestDto.getNombre() + " no ha sido actualizado");
            return new ResponseEntity((Object)new Mensaje("Error: Tipo de Insumo" + detalleTipoInsumoRequestDto.getNombre() + " no ha sido actualizado"), HttpStatus.BAD_REQUEST);
        }
        catch (Exception ex) {
            this.logger.error(ex.getMessage());
            return new ResponseEntity((Object)new Mensaje(ex.getMessage()), HttpStatus.METHOD_NOT_ALLOWED);
        }
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @PutMapping(value={"/delete/{id_tipoinsumo}"})
    public ResponseEntity<?> delete(@RequestBody TipoInsumoDto tipoInsumoDto, @PathVariable(value="id_tipoinsumo") Integer id_tipoinsumo) {
        try {
            if (!this.tipoInsumoService.existsById(id_tipoinsumo)) {
                this.logger.warn("No existe el id del tipo de insumo solicitado id: " + id_tipoinsumo);
                return new ResponseEntity((Object)new Mensaje("No existe el id del tipo de insumo solicitado id: " + id_tipoinsumo), HttpStatus.NOT_FOUND);
            }
            TipoInsumo tipoInsumo = this.tipoInsumoService.getTipoInsumo(id_tipoinsumo);
            int valor = tipoInsumo.getActivo() == 1 ? 2 : 1;
            tipoInsumo.setActivo(valor);
            tipoInsumo.setFechaModificacion(this.fechaActual);
            this.tipoInsumoService.addTipoInsumo(tipoInsumo);
            this.logger.warn("Estatus del Tipo de Insumo actualizado");
            return new ResponseEntity((Object)new Mensaje("Estatus del Tipo de Insumo actualizado"), HttpStatus.OK);
        }
        catch (Exception ex) {
            this.logger.error(ex.getMessage());
            return new ResponseEntity((Object)new Mensaje(ex.getMessage()), HttpStatus.METHOD_NOT_ALLOWED);
        }
    }
}

