/*
 * Decompiled with CFR 0.152.
 */
package com.dacrt.SBIABackend.controler;

import com.dacrt.SBIABackend.dto.Mensaje;
import com.dacrt.SBIABackend.dto.TipificacionRecursoDto;
import com.dacrt.SBIABackend.dto.responseDto.DetalleTipificacionRecursoResponseDto;
import com.dacrt.SBIABackend.entity.TipificacionRecurso;
import com.dacrt.SBIABackend.service.TificacionRecursoService;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/tipificacionrecurso"})
@CrossOrigin(origins={"*"})
public class TipificacionRecursoControler {
    @Autowired
    TificacionRecursoService tipificacionRecursoService;
    Logger logger = LoggerFactory.getLogger(TipificacionRecursoControler.class);
    Date fechaActual = new Date();

    @GetMapping(value={"/lista"})
    public ResponseEntity<List<DetalleTipificacionRecursoResponseDto>> list() {
        List<DetalleTipificacionRecursoResponseDto> list = this.tipificacionRecursoService.getTipificacionRecursos();
        return new ResponseEntity(list, HttpStatus.OK);
    }

    @GetMapping(value={"/detail/{id_tiporecurso}"})
    public ResponseEntity<TipificacionRecurso> getById(@PathVariable(value="id_tiporecurso") Integer id_tiporecurso) {
        if (!this.tipificacionRecursoService.existsById(id_tiporecurso)) {
            this.logger.warn("No existe el Tipo de Recurso: id_tiporecurso: " + id_tiporecurso);
            return new ResponseEntity((Object)new Mensaje("No existe el Tipo de Recurso: id_tiporecurso: " + id_tiporecurso), HttpStatus.NOT_FOUND);
        }
        DetalleTipificacionRecursoResponseDto detalleTipificacionRecurso = this.tipificacionRecursoService.getTipificacionRecursoById(id_tiporecurso);
        return new ResponseEntity((Object)detalleTipificacionRecurso, HttpStatus.OK);
    }

    @GetMapping(value={"/detailname/{nombre}"})
    public ResponseEntity<TipificacionRecurso> getByNombre(@PathVariable(value="nombre") String nombre) {
        if (!this.tipificacionRecursoService.existsByNombre(nombre)) {
            this.logger.warn("No existe el nombre del tipo de Recurso: nombre: " + nombre);
            return new ResponseEntity((Object)new Mensaje("No existe el nombre del tipo de Recurso: nombre: " + nombre), HttpStatus.NOT_FOUND);
        }
        TipificacionRecurso tipificacionRecurso = this.tipificacionRecursoService.getByNombre(nombre).get();
        return new ResponseEntity((Object)tipificacionRecurso, HttpStatus.OK);
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @PostMapping(value={"/create"})
    public ResponseEntity<?> create(@RequestBody TipificacionRecursoDto tipificacionRecursoDto) {
        try {
            if (StringUtils.isBlank((CharSequence)tipificacionRecursoDto.getNombre()) || tipificacionRecursoDto.getActivo() == 0) {
                this.logger.warn("Los campos son obligatorios");
                return new ResponseEntity((Object)new Mensaje("Los campos son obligatorios"), HttpStatus.BAD_REQUEST);
            }
            if (tipificacionRecursoDto.getNombre().length() > 300 || tipificacionRecursoDto.getActivo() > 1) {
                this.logger.warn("Verifique la longitud de los campos");
                return new ResponseEntity((Object)new Mensaje("Verifique la longitud de los campos"), HttpStatus.BAD_REQUEST);
            }
            if (this.tipificacionRecursoService.existsByNombre(tipificacionRecursoDto.getNombre())) {
                return new ResponseEntity((Object)new Mensaje("El nombre del Tipo de Recurso ya existe"), HttpStatus.BAD_REQUEST);
            }
            TipificacionRecurso tipificacionRecurso = new TipificacionRecurso(tipificacionRecursoDto.getNombre(), tipificacionRecursoDto.getActivo(), tipificacionRecursoDto.getUsuario(), tipificacionRecursoDto.getFechaRegistro(), tipificacionRecursoDto.getFechaModificacion());
            TipificacionRecurso tipificacionRecurso2 = this.tipificacionRecursoService.addTipificacionRecurso(tipificacionRecurso);
            if (tipificacionRecurso2 != null) {
                this.logger.warn("Tipificaci\u00f3n de Recurso creado: nombre: " + tipificacionRecursoDto.getNombre());
                return new ResponseEntity((Object)new Mensaje("Tipificaci\u00f3n de Recurso creado"), HttpStatus.OK);
            }
            this.logger.warn("Error tipo de Recurso no pudo ser creado: nombre: " + tipificacionRecursoDto.getNombre());
            return new ResponseEntity((Object)new Mensaje("Error tipo de Recurso no pudo ser creado: nombre: " + tipificacionRecursoDto.getNombre()), HttpStatus.BAD_REQUEST);
        }
        catch (Exception ex) {
            this.logger.error(ex.getMessage());
            return new ResponseEntity((Object)new Mensaje(ex.getMessage()), HttpStatus.METHOD_NOT_ALLOWED);
        }
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @PutMapping(value={"/update/{id_tiporecurso}"})
    public ResponseEntity<?> update(@PathVariable(value="id_tiporecurso") Integer id_tiporecurso, @RequestBody TipificacionRecursoDto tipificacionRecursoDto) {
        try {
            if (!this.tipificacionRecursoService.existsById(id_tiporecurso)) {
                this.logger.warn("No existe el Tipo de Recurso id: " + id_tiporecurso);
                return new ResponseEntity((Object)new Mensaje("No existe el Tipo de Recurso id: " + id_tiporecurso), HttpStatus.NOT_FOUND);
            }
            if (StringUtils.isBlank((CharSequence)tipificacionRecursoDto.getNombre()) || tipificacionRecursoDto.getActivo() == 0) {
                this.logger.warn("Los campos son obligatorios");
                return new ResponseEntity((Object)new Mensaje("Los campos son obligatorios"), HttpStatus.BAD_REQUEST);
            }
            if (this.tipificacionRecursoService.existsByNombre(tipificacionRecursoDto.getNombre()) && this.tipificacionRecursoService.getByNombre(tipificacionRecursoDto.getNombre()).get().getId_tiporecurso() != id_tiporecurso.intValue()) {
                this.logger.warn("El nombre " + tipificacionRecursoDto.getNombre() + "del Tipo de Recurso ya existe");
                return new ResponseEntity((Object)new Mensaje("El nombre " + tipificacionRecursoDto.getNombre() + "del Tipo de Recurso ya existe"), HttpStatus.BAD_REQUEST);
            }
            TipificacionRecurso tipificacionRecurso = this.tipificacionRecursoService.getTipificacionRecurso(id_tiporecurso);
            tipificacionRecurso.setNombre(tipificacionRecursoDto.getNombre());
            tipificacionRecurso.setActivo(tipificacionRecursoDto.getActivo());
            tipificacionRecurso.setUsuario(tipificacionRecursoDto.getUsuario());
            tipificacionRecurso.setFechaModificacion(tipificacionRecursoDto.getFechaModificacion());
            tipificacionRecurso.setFechaRegistro(tipificacionRecursoDto.getFechaRegistro());
            TipificacionRecurso tipificacionRecurso2 = this.tipificacionRecursoService.editTipoRecurso(id_tiporecurso, tipificacionRecurso);
            if (tipificacionRecurso2 != null) {
                this.logger.warn("Tipo de Recurso actualizado: nombre: " + tipificacionRecursoDto.getNombre());
                return new ResponseEntity((Object)new Mensaje("Tipo de Recurso actualizado: nombre: " + tipificacionRecursoDto.getNombre()), HttpStatus.OK);
            }
            this.logger.warn("Error tipo de Recurso no pudo ser actualizado: nombre: " + tipificacionRecursoDto.getNombre());
            return new ResponseEntity((Object)new Mensaje("Error tipo de Recurso no pudo ser actualizado: nombre: " + tipificacionRecursoDto.getNombre()), HttpStatus.BAD_REQUEST);
        }
        catch (Exception ex) {
            this.logger.error(ex.getMessage());
            return new ResponseEntity((Object)new Mensaje(ex.getMessage()), HttpStatus.METHOD_NOT_ALLOWED);
        }
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @PutMapping(value={"/delete/{id_tiporecurso}"})
    public ResponseEntity<?> delete(@PathVariable(value="id_tiporecurso") Integer id_tiporecurso, @RequestBody TipificacionRecurso tipificacionRecurso) {
        try {
            if (!this.tipificacionRecursoService.existsById(id_tiporecurso)) {
                this.logger.warn("No existe el id del tipo de recurso solicitado id: " + id_tiporecurso);
                return new ResponseEntity((Object)new Mensaje("No existe el id del tipo de recurso solicitado id: " + id_tiporecurso), HttpStatus.NOT_FOUND);
            }
            TipificacionRecurso tipificacionRecurso2 = this.tipificacionRecursoService.getTipificacionRecurso(id_tiporecurso);
            int valor = tipificacionRecurso2.getActivo() == 1 ? 2 : 1;
            tipificacionRecurso2.setActivo(valor);
            tipificacionRecurso2.setFechaModificacion(this.fechaActual);
            tipificacionRecurso2 = this.tipificacionRecursoService.editTipoRecurso(id_tiporecurso, tipificacionRecurso2);
            if (tipificacionRecurso2 != null) {
                this.logger.warn("Estatus del Tipo de Recurso actualizado");
                return new ResponseEntity((Object)new Mensaje("Estatus del Tipo de Recurso actualizado"), HttpStatus.OK);
            }
            this.logger.warn("Error el estatus del tipo de Recurso no pudo ser actualizado: nombre: " + tipificacionRecurso2.getNombre());
            return new ResponseEntity((Object)new Mensaje("Error el estatus del tipo de Recurso no pudo ser actualizado: nombre: " + tipificacionRecurso2.getNombre()), HttpStatus.BAD_REQUEST);
        }
        catch (Exception ex) {
            this.logger.error(ex.getMessage());
            return new ResponseEntity((Object)new Mensaje(ex.getMessage()), HttpStatus.METHOD_NOT_ALLOWED);
        }
    }
}

