/*
 * Decompiled with CFR 0.152.
 */
package com.dacrt.SBIABackend.controler;

import com.dacrt.SBIABackend.dto.Mensaje;
import com.dacrt.SBIABackend.dto.ReportesRegulatoriosDto;
import com.dacrt.SBIABackend.entity.ReportesRegulatorios;
import com.dacrt.SBIABackend.service.ReportesRegulatoriosService;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/reportesregulatorios"})
@CrossOrigin(origins={"*"})
public class ReportesRegulatoriosControler {
    @Autowired
    ReportesRegulatoriosService reportesregulatoriosService;
    Logger logger = LoggerFactory.getLogger(ReportesRegulatoriosControler.class);
    Date fechaActual = new Date();

    @GetMapping(value={"/lista"})
    public ResponseEntity<List<ReportesRegulatorios>> list() {
        List<ReportesRegulatorios> list = this.reportesregulatoriosService.list();
        return new ResponseEntity(list, HttpStatus.OK);
    }

    @GetMapping(value={"/detail/{id_reportesregulatorios}"})
    public ResponseEntity<ReportesRegulatorios> getById(@PathVariable(value="id_reportesregulatorios") Long id_reportesregulatorios) {
        if (!this.reportesregulatoriosService.existsById(id_reportesregulatorios)) {
            return new ResponseEntity((Object)new Mensaje("No existe el Reporte Regulatorio"), HttpStatus.NOT_FOUND);
        }
        ReportesRegulatorios reportesregulatorios = this.reportesregulatoriosService.getOne(id_reportesregulatorios).get();
        return new ResponseEntity((Object)reportesregulatorios, HttpStatus.OK);
    }

    @GetMapping(value={"/detailname/{nombre}"})
    public ResponseEntity<ReportesRegulatorios> getByNombre(@PathVariable(value="nombre") String nombre) {
        if (!this.reportesregulatoriosService.existsByNombre(nombre)) {
            return new ResponseEntity((Object)new Mensaje("No existe el Reporte Regulatorio"), HttpStatus.NOT_FOUND);
        }
        ReportesRegulatorios reportesregulatorios = this.reportesregulatoriosService.getByNombre(nombre).get();
        return new ResponseEntity((Object)reportesregulatorios, HttpStatus.OK);
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @PostMapping(value={"/create"})
    public ResponseEntity<?> create(@RequestBody ReportesRegulatoriosDto reportesregulatoriosDto) {
        try {
            if (StringUtils.isBlank((CharSequence)reportesregulatoriosDto.getNombre())) {
                return new ResponseEntity((Object)new Mensaje("El nombre del Reporte Regulatorio es obligatorio"), HttpStatus.BAD_REQUEST);
            }
            if (this.reportesregulatoriosService.existsByNombre(reportesregulatoriosDto.getNombre())) {
                return new ResponseEntity((Object)new Mensaje("El nombre del Reporte Regulatorio ya existe"), HttpStatus.BAD_REQUEST);
            }
            ReportesRegulatorios reportesregulatorios = new ReportesRegulatorios(reportesregulatoriosDto.getNombre(), reportesregulatoriosDto.getDescripcion(), reportesregulatoriosDto.getUsuario(), reportesregulatoriosDto.getFechaRegistro(), reportesregulatoriosDto.getFechaModificacion());
            this.reportesregulatoriosService.save(reportesregulatorios);
            return new ResponseEntity((Object)new Mensaje("Reporte Regulatorio creado"), HttpStatus.OK);
        }
        catch (DataAccessException ex) {
            this.logger.error(ex.getMessage());
            return new ResponseEntity((Object)new Mensaje(ex.getMessage()), HttpStatus.METHOD_NOT_ALLOWED);
        }
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @PutMapping(value={"/update/{id_reportesregulatorios}"})
    public ResponseEntity<?> update(@PathVariable(value="id_reportesregulatorios") Long id_reportesregulatorios, @RequestBody ReportesRegulatoriosDto reportesregulatoriosDto) {
        try {
            if (!this.reportesregulatoriosService.existsById(id_reportesregulatorios)) {
                return new ResponseEntity((Object)new Mensaje("No existe el Reporte Regulatorio"), HttpStatus.NOT_FOUND);
            }
            if (this.reportesregulatoriosService.existsByNombre(reportesregulatoriosDto.getNombre()) && this.reportesregulatoriosService.getByNombre(reportesregulatoriosDto.getNombre()).get().getId_reportesregulatorios() != id_reportesregulatorios) {
                return new ResponseEntity((Object)new Mensaje("El nombre del Reporte Regulatorio ya existe"), HttpStatus.BAD_REQUEST);
            }
            if (StringUtils.isBlank((CharSequence)reportesregulatoriosDto.getNombre())) {
                return new ResponseEntity((Object)new Mensaje("El nombre del Reporte Regulatorio es obligatorio"), HttpStatus.BAD_REQUEST);
            }
            ReportesRegulatorios reportesregulatorios = this.reportesregulatoriosService.getOne(id_reportesregulatorios).get();
            reportesregulatorios.setNombre(reportesregulatoriosDto.getNombre());
            reportesregulatorios.setDescripcion(reportesregulatoriosDto.getDescripcion());
            reportesregulatorios.setUsuario(reportesregulatoriosDto.getUsuario());
            reportesregulatorios.setFechaModificacion(reportesregulatoriosDto.getFechaModificacion());
            reportesregulatorios.setFechaRegistro(reportesregulatoriosDto.getFechaRegistro());
            this.reportesregulatoriosService.save(reportesregulatorios);
            return new ResponseEntity((Object)new Mensaje("Reporte Regulatorio actualizado"), HttpStatus.OK);
        }
        catch (DataAccessException ex) {
            this.logger.error(ex.getMessage());
            return new ResponseEntity((Object)new Mensaje(ex.getMessage()), HttpStatus.METHOD_NOT_ALLOWED);
        }
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @DeleteMapping(value={"/delete/{id_reportesregulatorios}"})
    public ResponseEntity<?> delete(@PathVariable(value="id_reportesregulatorios") Long id_reportesregulatorios) {
        try {
            if (!this.reportesregulatoriosService.existsById(id_reportesregulatorios)) {
                return new ResponseEntity((Object)new Mensaje("No existe el Reporte Regulatorio"), HttpStatus.NOT_FOUND);
            }
            this.reportesregulatoriosService.delete(id_reportesregulatorios);
            return new ResponseEntity((Object)new Mensaje("Reporte Regulatorio eliminado"), HttpStatus.OK);
        }
        catch (DataAccessException ex) {
            this.logger.error(ex.getMessage());
            return new ResponseEntity((Object)new Mensaje(ex.getMessage()), HttpStatus.METHOD_NOT_ALLOWED);
        }
    }
}

