/*
 * Decompiled with CFR 0.152.
 */
package com.dacrt.SBIABackend.controler;

import com.dacrt.SBIABackend.dto.Mensaje;
import com.dacrt.SBIABackend.dto.requestDto.DetalleProveedoresRequestDto;
import com.dacrt.SBIABackend.dto.requestDto.ProveedoresRequestDto;
import com.dacrt.SBIABackend.dto.responseDto.DetalleProveedoresResponseDto;
import com.dacrt.SBIABackend.dto.responseDto.ProveedoresResponseDto;
import com.dacrt.SBIABackend.entity.Proveedores;
import com.dacrt.SBIABackend.exception.ResourceNotFoundException;
import com.dacrt.SBIABackend.service.ProveedoresService;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/proveedores"})
@CrossOrigin(origins={"*"})
public class ProveedoresControler {
    @Autowired
    ProveedoresService proveedoresService;
    Logger logger = LoggerFactory.getLogger(ProveedoresControler.class);
    Date fechaActual = new Date();

    @Autowired
    public ProveedoresControler(ProveedoresService proveedoresService) {
        this.proveedoresService = proveedoresService;
    }

    @GetMapping(value={"/lista"})
    public ResponseEntity<List<DetalleProveedoresResponseDto>> list() {
        List<DetalleProveedoresResponseDto> proveedoresResponseDtos = this.proveedoresService.getProveedores();
        if (proveedoresResponseDtos == null || proveedoresResponseDtos.isEmpty()) {
            ResourceNotFoundException recurso = new ResourceNotFoundException();
            return new ResponseEntity((Object)recurso.ResourceNotFoundExceptionList("proveedores"), HttpStatus.NOT_FOUND);
        }
        return new ResponseEntity(proveedoresResponseDtos, HttpStatus.OK);
    }

    @GetMapping(value={"/cantidadProveedores"})
    public ResponseEntity<?> countProveedores() {
        long countProveedores = this.proveedoresService.countProveedores();
        return new ResponseEntity((Object)countProveedores, HttpStatus.OK);
    }

    @GetMapping(value={"/detail/{idProveedores}"})
    public ResponseEntity<?> getProveedores(@PathVariable(value="idProveedores") Integer idProveedores) {
        if (!this.proveedoresService.existsById(idProveedores)) {
            this.logger.warn("No existe el proveedor con id: " + idProveedores);
            return new ResponseEntity((Object)new ResourceNotFoundException("proveedores", "idProveedores", idProveedores), HttpStatus.NOT_FOUND);
        }
        DetalleProveedoresResponseDto detalleProveedoresResponseDto = this.proveedoresService.getProveedoresById(idProveedores);
        return new ResponseEntity((Object)detalleProveedoresResponseDto, HttpStatus.OK);
    }

    @GetMapping(value={"/detailname/{nombre}"})
    public ResponseEntity<Proveedores> getByNombre(@PathVariable(value="nombre") String nombre) {
        if (!this.proveedoresService.existsByNombre(nombre)) {
            this.logger.warn("No existe el Proveedor: " + nombre);
            return new ResponseEntity((Object)new Mensaje("No existe el Proveedor"), HttpStatus.NOT_FOUND);
        }
        Proveedores proveedores = this.proveedoresService.getByNombre(nombre).get();
        return new ResponseEntity((Object)proveedores, HttpStatus.OK);
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @PostMapping(value={"/create"})
    public ResponseEntity<?> addProveedores(@RequestBody ProveedoresRequestDto proveedoresRequestDto) {
        try {
            if (StringUtils.isBlank((CharSequence)proveedoresRequestDto.getCdProveedores()) || StringUtils.isBlank((CharSequence)proveedoresRequestDto.getNombre()) || StringUtils.isBlank((CharSequence)proveedoresRequestDto.getDescripcion()) || StringUtils.isBlank((CharSequence)proveedoresRequestDto.getRuc()) || proveedoresRequestDto.getActivo() == 0 || proveedoresRequestDto.getTipoProveedores() == 0 || proveedoresRequestDto.getSoporta() == 0 || StringUtils.isBlank((CharSequence)proveedoresRequestDto.getInfoContrato()) || proveedoresRequestDto.getEmpRelacionado() == 0 || proveedoresRequestDto.getPoseeContraProvee() == 0 || proveedoresRequestDto.getSoportaSol() == 0 || proveedoresRequestDto.getProcesaDatos() == 0 || proveedoresRequestDto.getPoseeBCP() == 0) {
                this.logger.warn("Los campos del proveedor son obligatorios");
                return new ResponseEntity((Object)new Mensaje("Los campos son obligatorios"), HttpStatus.BAD_REQUEST);
            }
            if (proveedoresRequestDto.getSoportaSol() == 1 && (proveedoresRequestDto.getTiempoAtenc() == 0 || proveedoresRequestDto.getTiempoResp() == 0)) {
                this.logger.warn("Los campos tiempo de Atenci\u00f3n y tiempo de respuesta deben tener informaci\u00f3n");
                return new ResponseEntity((Object)new Mensaje("Los campos tiempo de Atenci\u00f3n y tiempo de respuesta deben tener informaci\u00f3n"), HttpStatus.BAD_REQUEST);
            }
            if (proveedoresRequestDto.getPoseeContraProvee() == 1 && StringUtils.isBlank((CharSequence)proveedoresRequestDto.getNombreContraProvee())) {
                this.logger.warn("El campo de Proveedor Diferente deben tener informaci\u00f3n");
                return new ResponseEntity((Object)new Mensaje("El campo de Proveedor Diferente deben tener informaci\u00f3n"), HttpStatus.BAD_REQUEST);
            }
            if (proveedoresRequestDto.getProcesaDatos() == 1 && (proveedoresRequestDto.getTmrpoProv() == 0 || proveedoresRequestDto.getTmrtoProv() == 0)) {
                this.logger.warn("\"Los campos de Tiempo Medio de Recuperaci\u00f3n y Tiempo de P\u00e9rdida de datos deben tener informaci\u00f3n");
                return new ResponseEntity((Object)new Mensaje("Los campos de Tiempo Medio de Recuperaci\u00f3n y Tiempo de P\u00e9rdida de datos deben tener informaci\u00f3n"), HttpStatus.BAD_REQUEST);
            }
            if (proveedoresRequestDto.getCdProveedores().length() > 6 || proveedoresRequestDto.getNombre().length() > 200 || proveedoresRequestDto.getDescripcion().length() > 500 || proveedoresRequestDto.getRuc().length() > 100 || String.valueOf(proveedoresRequestDto.getActivo()).length() > 1 || String.valueOf(proveedoresRequestDto.getTipoProveedores()).length() > 1 || String.valueOf(proveedoresRequestDto.getSoporta()).length() > 1 || proveedoresRequestDto.getInfoContrato().length() > 500 || String.valueOf(proveedoresRequestDto.getSoporta()).length() > 1 || String.valueOf(proveedoresRequestDto.getEmpRelacionado()).length() > 1 || String.valueOf(proveedoresRequestDto.getPoseeContraProvee()).length() > 1 || String.valueOf(proveedoresRequestDto.getSoportaSol()).length() > 1 || String.valueOf(proveedoresRequestDto.getProcesaDatos()).length() > 1 || String.valueOf(proveedoresRequestDto.getPoseeBCP()).length() > 1) {
                this.logger.warn("Verifique el tama\u00f1o del contenido de los campos");
                return new ResponseEntity((Object)new Mensaje("Verifique el tama\u00f1o del contenido de los campos"), HttpStatus.BAD_REQUEST);
            }
            if (this.proveedoresService.existsBycdProveedores(proveedoresRequestDto.getCdProveedores())) {
                this.logger.warn("El c\u00f3digo del proveedor ya existe");
                return new ResponseEntity((Object)new Mensaje("El c\u00f3digo del proveedor ya existe"), HttpStatus.BAD_REQUEST);
            }
            if (this.proveedoresService.existsByNombre(proveedoresRequestDto.getNombre())) {
                this.logger.warn("El nombre del proveedor ya existe");
                return new ResponseEntity((Object)new Mensaje("El nombre del proveedor ya existe"), HttpStatus.BAD_REQUEST);
            }
            ProveedoresResponseDto proveedoresResponseDto = this.proveedoresService.addProveedores(proveedoresRequestDto);
            this.logger.warn("Proveedor creado");
            return new ResponseEntity((Object)new Mensaje("Proveedor creado"), HttpStatus.OK);
        }
        catch (DataAccessException ex) {
            this.logger.error(ex.getMessage());
            return new ResponseEntity((Object)new Mensaje(ex.getMessage()), HttpStatus.METHOD_NOT_ALLOWED);
        }
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @PutMapping(value={"/update/{idProveedores}"})
    public ResponseEntity<?> update(@RequestBody DetalleProveedoresRequestDto detalleProveedoresRequestDto, @PathVariable(value="idProveedores") Integer idProveedores) {
        try {
            if (!this.proveedoresService.existsById(idProveedores)) {
                this.logger.warn("No existe el id del proveedor solicitado con id: " + idProveedores);
                return new ResponseEntity((Object)new Mensaje("No existe el id del proveedor solicitadocon id: " + idProveedores), HttpStatus.NOT_FOUND);
            }
            if (StringUtils.isBlank((CharSequence)detalleProveedoresRequestDto.getCdProveedores()) || StringUtils.isBlank((CharSequence)detalleProveedoresRequestDto.getNombre()) || StringUtils.isBlank((CharSequence)detalleProveedoresRequestDto.getDescripcion()) || StringUtils.isBlank((CharSequence)detalleProveedoresRequestDto.getRuc()) || StringUtils.isBlank((CharSequence)detalleProveedoresRequestDto.getInfoContrato()) || detalleProveedoresRequestDto.getActivo() == 0 || detalleProveedoresRequestDto.getTipoProveedores() == 0 || detalleProveedoresRequestDto.getSoporta() == 0 || detalleProveedoresRequestDto.getEmpRelacionado() == 0 || detalleProveedoresRequestDto.getPoseeContraProvee() == 0 || detalleProveedoresRequestDto.getSoportaSol() == 0 || detalleProveedoresRequestDto.getProcesaDatos() == 0 || detalleProveedoresRequestDto.getPoseeBCP() == 0) {
                this.logger.warn("Los campos son obligatorios");
                return new ResponseEntity((Object)new Mensaje("Los campos son obligatorios"), HttpStatus.BAD_REQUEST);
            }
            if (detalleProveedoresRequestDto.getSoportaSol() == 1 && (detalleProveedoresRequestDto.getTiempoAtenc() == 0 || detalleProveedoresRequestDto.getTiempoResp() == 0)) {
                this.logger.warn("Los campos tiempo de Atenci\u00f3n y tiempo de respuesta deben tener informaci\u00f3n");
                return new ResponseEntity((Object)new Mensaje("Los campos tiempo de Atenci\u00f3n y tiempo de respuesta deben tener informaci\u00f3n"), HttpStatus.BAD_REQUEST);
            }
            if (detalleProveedoresRequestDto.getPoseeContraProvee() == 1 && StringUtils.isBlank((CharSequence)detalleProveedoresRequestDto.getNombreContraProvee())) {
                this.logger.warn("El campo de Proveedor Diferente deben tener informaci\u00f3n");
                return new ResponseEntity((Object)new Mensaje("El campo de Proveedor Diferente deben tener informaci\u00f3n"), HttpStatus.BAD_REQUEST);
            }
            if (detalleProveedoresRequestDto.getProcesaDatos() == 1 && (detalleProveedoresRequestDto.getTmrpoProv() == 0 || detalleProveedoresRequestDto.getTmrtoProv() == 0)) {
                this.logger.warn("Los campos de Tiempo Medio de Recuperaci\u00f3n y Tiempo de P\u00e9rdida de datos deben tener informaci\u00f3n");
                return new ResponseEntity((Object)new Mensaje("Los campos de Tiempo Medio de Recuperaci\u00f3n y Tiempo de P\u00e9rdida de datos deben tener informaci\u00f3n"), HttpStatus.BAD_REQUEST);
            }
            if (detalleProveedoresRequestDto.getCdProveedores().length() > 6 || detalleProveedoresRequestDto.getNombre().length() > 200 || detalleProveedoresRequestDto.getDescripcion().length() > 500 || detalleProveedoresRequestDto.getRuc().length() > 100 || String.valueOf(detalleProveedoresRequestDto.getActivo()).length() > 1 || String.valueOf(detalleProveedoresRequestDto.getTipoProveedores()).length() > 1 || String.valueOf(detalleProveedoresRequestDto.getSoporta()).length() > 1 || detalleProveedoresRequestDto.getInfoContrato().length() > 500 || String.valueOf(detalleProveedoresRequestDto.getSoporta()).length() > 1 || String.valueOf(detalleProveedoresRequestDto.getEmpRelacionado()).length() > 1 || String.valueOf(detalleProveedoresRequestDto.getPoseeContraProvee()).length() > 1 || String.valueOf(detalleProveedoresRequestDto.getSoportaSol()).length() > 1 || String.valueOf(detalleProveedoresRequestDto.getProcesaDatos()).length() > 1 || String.valueOf(detalleProveedoresRequestDto.getPoseeBCP()).length() > 1) {
                this.logger.warn("Verifique el tama\u00f1o del contenido de los campos");
                return new ResponseEntity((Object)new Mensaje("Verifique el tama\u00f1o del contenido de los campos"), HttpStatus.BAD_REQUEST);
            }
            if (this.proveedoresService.existsByNombre(detalleProveedoresRequestDto.getNombre()) && this.proveedoresService.getByNombre(detalleProveedoresRequestDto.getNombre()).get().getIdProveedores() != idProveedores.intValue()) {
                this.logger.warn("El nombre del Proveedor " + detalleProveedoresRequestDto.getNombre() + "  ya existe");
                return new ResponseEntity((Object)new Mensaje("El nombre del Proveedor " + detalleProveedoresRequestDto.getNombre() + " ya existe"), HttpStatus.BAD_REQUEST);
            }
            if (this.proveedoresService.existsBycdProveedores(detalleProveedoresRequestDto.getCdProveedores()) && this.proveedoresService.getBycdProveedores(detalleProveedoresRequestDto.getCdProveedores()).get().getIdProveedores() != idProveedores.intValue()) {
                this.logger.warn("El c\u00f3digo del proveedor ya existe");
                return new ResponseEntity((Object)new Mensaje("El c\u00f3digo del Proveedor " + detalleProveedoresRequestDto.getCdProveedores() + " ya existe y es id " + idProveedores), HttpStatus.BAD_REQUEST);
            }
            this.proveedoresService.editProveedores(idProveedores, detalleProveedoresRequestDto);
            this.logger.warn("Proveedor actualizado");
            return new ResponseEntity((Object)new Mensaje("Proveedor actualizado"), HttpStatus.OK);
        }
        catch (DataAccessException ex) {
            this.logger.error(ex.getMessage());
            return new ResponseEntity((Object)new Mensaje(ex.getMessage()), HttpStatus.METHOD_NOT_ALLOWED);
        }
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @DeleteMapping(value={"/delete/{idProveedores}"})
    public ResponseEntity<?> deleteProveedores(DetalleProveedoresRequestDto detalleProveedoresRequestDto, @PathVariable(value="idProveedores") Integer idProveedores) {
        try {
            if (!this.proveedoresService.existsById(idProveedores)) {
                this.logger.warn("No existe el id del proveedor solicitado");
                return new ResponseEntity((Object)new Mensaje("No existe el id del proveedor solicitado"), HttpStatus.NOT_FOUND);
            }
            Proveedores proveedor = this.proveedoresService.getProveedores(idProveedores);
            int valor = proveedor.getActivo() == 1 ? 2 : 1;
            proveedor.setActivo(valor);
            proveedor.setFechaModificacion(this.fechaActual);
            this.proveedoresService.save(proveedor);
            this.logger.warn("Estatus del Proveedor actualizado");
            return new ResponseEntity((Object)new Mensaje("Estatus del Proveedor actualizado"), HttpStatus.OK);
        }
        catch (DataAccessException ex) {
            this.logger.error(ex.getMessage());
            return new ResponseEntity((Object)new Mensaje(ex.getMessage()), HttpStatus.METHOD_NOT_ALLOWED);
        }
    }
}

