/*
 * Decompiled with CFR 0.152.
 */
package com.dacrt.SBIABackend.controler;

import com.dacrt.SBIABackend.dto.Mensaje;
import com.dacrt.SBIABackend.dto.ParametrosDto;
import com.dacrt.SBIABackend.dto.responseDto.DetalleParametrosResponseDto;
import com.dacrt.SBIABackend.entity.Parametros;
import com.dacrt.SBIABackend.service.ParametrosServiceImpl;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/parametros"})
@CrossOrigin(origins={"*"})
public class ParametrosControler {
    @Autowired
    ParametrosServiceImpl parametrosServiceImpl;
    Logger logger = LoggerFactory.getLogger(ParametrosControler.class);
    Date fechaActual = new Date();

    @GetMapping(value={"/lista"})
    public ResponseEntity<List<DetalleParametrosResponseDto>> list() {
        List<DetalleParametrosResponseDto> detalleParametrosResponseDtos = this.parametrosServiceImpl.getParametros();
        return new ResponseEntity(detalleParametrosResponseDtos, HttpStatus.OK);
    }

    @GetMapping(value={"/listado/{Idtabla}"})
    public ResponseEntity<List<Parametros>> getNombresParametros(@PathVariable(value="Idtabla") String Idtabla) {
        List<Parametros> parametros = this.parametrosServiceImpl.findAllByIdtabla(Idtabla);
        return ResponseEntity.ok(parametros);
    }

    @GetMapping(value={"/listadoParametro/{Idtabla}/{Valor}"})
    public ResponseEntity<List<Parametros>> buscarParametros(@PathVariable(value="Idtabla") String Idtabla, @PathVariable(value="Valor") String Valor) {
        List<Parametros> parametros = this.parametrosServiceImpl.buscarParametro(Idtabla, Valor);
        return ResponseEntity.ok(parametros);
    }

    @GetMapping(value={"/detail/{id_parametros}"})
    public ResponseEntity<DetalleParametrosResponseDto> getById(@PathVariable(value="id_parametros") Integer id_parametros) {
        if (!this.parametrosServiceImpl.existsById(id_parametros)) {
            this.logger.warn("No existe el Par\u00e1metro: " + id_parametros);
            return new ResponseEntity((Object)new Mensaje("No existe el Par\u00e1metro: " + id_parametros), HttpStatus.NOT_FOUND);
        }
        Parametros parametro = this.parametrosServiceImpl.getOne(id_parametros).get();
        Optional<Parametros> deEstatus = this.parametrosServiceImpl.getByIdtablaAndValor("ESTATUS", String.valueOf(parametro.getActivo()));
        int id_estatus = Integer.parseInt(deEstatus.get().getValor());
        String boton = id_estatus == 1 ? "Desactivar" : "Activar";
        String estatus = deEstatus.get().getNombre();
        DetalleParametrosResponseDto detalleParametros = new DetalleParametrosResponseDto(parametro.getId_parametros(), parametro.getIdtabla(), parametro.getNombre(), parametro.getValor(), parametro.getActivo(), estatus, boton, parametro.getUsuario(), parametro.getFechaRegistro(), parametro.getFechaModificacion());
        return new ResponseEntity((Object)detalleParametros, HttpStatus.OK);
    }

    @GetMapping(value={"/detailname/{nombre}"})
    public ResponseEntity<Parametros> getByNombre(@PathVariable(value="nombre") String nombre) {
        if (!this.parametrosServiceImpl.existsByNombre(nombre)) {
            this.logger.warn("No existe el nombre del Par\u00e1metro: " + nombre);
            return new ResponseEntity((Object)new Mensaje("No existe el nombre del Par\u00e1metro: " + nombre), HttpStatus.NOT_FOUND);
        }
        Parametros parametros = this.parametrosServiceImpl.getByNombre(nombre).get();
        return new ResponseEntity((Object)parametros, HttpStatus.OK);
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @PostMapping(value={"/create"})
    public ResponseEntity<?> create(@RequestBody ParametrosDto parametrosDto) {
        try {
            if (StringUtils.isBlank((CharSequence)parametrosDto.getNombre()) && StringUtils.isBlank((CharSequence)parametrosDto.getIdtabla()) && StringUtils.isBlank((CharSequence)parametrosDto.getValor()) && parametrosDto.getActivo() != 0) {
                this.logger.warn("Error: Los campos son obligatorio");
                return new ResponseEntity((Object)new Mensaje("Error: Los campos son obligatorio"), HttpStatus.BAD_REQUEST);
            }
            if (parametrosDto.getIdtabla().length() > 400 || parametrosDto.getNombre().length() > 100 || parametrosDto.getValor().length() > 500 || String.valueOf(parametrosDto.getActivo()).length() > 1) {
                this.logger.warn("Verifique el tama\u00f1o del contenido de los campos");
                return new ResponseEntity((Object)new Mensaje("Verifique el tama\u00f1o del contenido de los campos"), HttpStatus.BAD_REQUEST);
            }
            if (this.parametrosServiceImpl.existsByIdtablaAndNombreAndValor(parametrosDto.getIdtabla(), parametrosDto.getNombre(), parametrosDto.getValor())) {
                this.logger.warn("El Par\u00e1metro ya existe");
                return new ResponseEntity((Object)new Mensaje("El Par\u00e1metro ya existe"), HttpStatus.BAD_REQUEST);
            }
            Parametros parametro = new Parametros(parametrosDto.getIdtabla(), parametrosDto.getNombre(), parametrosDto.getValor(), parametrosDto.getActivo(), parametrosDto.getUsuario(), parametrosDto.getFechaRegistro(), parametrosDto.getFechaModificacion());
            this.parametrosServiceImpl.save(parametro);
            this.logger.warn("Par\u00e1metro creado: Tabla: " + parametrosDto.getIdtabla() + " Nombre: " + parametrosDto.getNombre() + " Valor: " + parametrosDto.getValor());
            return new ResponseEntity((Object)new Mensaje("Par\u00e1metro creado: " + parametrosDto.getIdtabla() + '-' + parametrosDto.getNombre() + '-' + parametrosDto.getValor()), HttpStatus.OK);
        }
        catch (DataAccessException ex) {
            this.logger.error(ex.getMessage());
            return new ResponseEntity((Object)new Mensaje(ex.getMessage()), HttpStatus.METHOD_NOT_ALLOWED);
        }
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @PutMapping(value={"/update/{id_parametros}"})
    public ResponseEntity<?> update(@PathVariable(value="id_parametros") Integer id_parametros, @RequestBody ParametrosDto parametrosDto) {
        try {
            if (!this.parametrosServiceImpl.existsById(id_parametros)) {
                this.logger.warn("No existe el Par\u00e1metro: " + id_parametros);
                return new ResponseEntity((Object)new Mensaje("No existe el Par\u00e1metro" + id_parametros), HttpStatus.NOT_FOUND);
            }
            if (StringUtils.isBlank((CharSequence)parametrosDto.getNombre()) && StringUtils.isBlank((CharSequence)parametrosDto.getIdtabla()) && StringUtils.isBlank((CharSequence)parametrosDto.getValor()) && parametrosDto.getActivo() != 0) {
                this.logger.warn("Error: Los campos son obligatorio");
                return new ResponseEntity((Object)new Mensaje("Error: Los campos son obligatorio"), HttpStatus.BAD_REQUEST);
            }
            if (parametrosDto.getIdtabla().length() > 400 || parametrosDto.getNombre().length() > 100 || parametrosDto.getValor().length() > 500 || String.valueOf(parametrosDto.getActivo()).length() > 1) {
                this.logger.warn("Verifique el tama\u00f1o del contenido de los campos");
                return new ResponseEntity((Object)new Mensaje("Verifique el tama\u00f1o del contenido de los campos"), HttpStatus.BAD_REQUEST);
            }
            if (this.parametrosServiceImpl.existsByIdtablaAndNombreAndValor(parametrosDto.getIdtabla(), parametrosDto.getNombre(), parametrosDto.getValor()) && this.parametrosServiceImpl.getByIdtablaAndNombreAndValor(parametrosDto.getIdtabla(), parametrosDto.getNombre(), parametrosDto.getValor()).get().getId_parametros() != id_parametros.intValue()) {
                this.logger.warn("El Par\u00e1metro ya existe");
                return new ResponseEntity((Object)new Mensaje("El Par\u00e1metro ya existe"), HttpStatus.BAD_REQUEST);
            }
            Parametros parametro = this.parametrosServiceImpl.getOne(id_parametros).get();
            parametro.setIdtabla(parametrosDto.getIdtabla());
            parametro.setNombre(parametrosDto.getNombre());
            parametro.setActivo(parametrosDto.getActivo());
            parametro.setValor(parametrosDto.getValor());
            parametro.setUsuario(parametrosDto.getUsuario());
            parametro.setFechaModificacion(this.fechaActual);
            parametro.setFechaRegistro(parametrosDto.getFechaRegistro());
            this.parametrosServiceImpl.save(parametro);
            this.logger.warn("Par\u00e1metro actualizado: Tabla: " + parametrosDto.getIdtabla() + " Nombre: " + parametrosDto.getNombre() + " Valor: " + parametrosDto.getValor());
            return new ResponseEntity((Object)new Mensaje("Par\u00e1metro actualizado: Tabla: " + parametrosDto.getIdtabla() + " Nombre: " + parametrosDto.getNombre() + " Valor: " + parametrosDto.getValor()), HttpStatus.OK);
        }
        catch (DataAccessException ex) {
            this.logger.error(ex.getMessage());
            return new ResponseEntity((Object)new Mensaje(ex.getMessage()), HttpStatus.METHOD_NOT_ALLOWED);
        }
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @PutMapping(value={"/delete/{id_parametros}"})
    public ResponseEntity<?> delete(@PathVariable(value="id_parametros") Integer id_parametros, @RequestBody ParametrosDto parametrosDto) {
        if (!this.parametrosServiceImpl.existsById(id_parametros)) {
            this.logger.warn("No existe el Par\u00e1metro: " + id_parametros);
            return new ResponseEntity((Object)new Mensaje("No existe el id del par\u00e1metro solicitado"), HttpStatus.NOT_FOUND);
        }
        Parametros parametro = this.parametrosServiceImpl.getOne(id_parametros).get();
        int valor = parametro.getActivo() == 1 ? 2 : 1;
        parametro.setIdtabla(parametro.getIdtabla());
        parametro.setNombre(parametro.getNombre());
        parametro.setActivo(valor);
        parametro.setValor(parametro.getValor());
        parametro.setUsuario(parametro.getUsuario());
        parametro.setFechaModificacion(this.fechaActual);
        parametro.setFechaRegistro(parametro.getFechaRegistro());
        this.parametrosServiceImpl.save(parametro);
        if (parametro.getActivo() == 1) {
            this.logger.warn("El Par\u00e1metro con id " + id_parametros + " fue activado");
            return new ResponseEntity((Object)new Mensaje("El Par\u00e1metro con id " + id_parametros + " fue activado"), HttpStatus.OK);
        }
        this.logger.warn("El Par\u00e1metro con id " + id_parametros + " fue desactivado");
        return new ResponseEntity((Object)new Mensaje("El Par\u00e1metro con id " + id_parametros + " fue desactivado"), HttpStatus.OK);
    }
}

