/*
 * Decompiled with CFR 0.152.
 */
package com.dacrt.SBIABackend.controler;

import com.dacrt.SBIABackend.dto.Mensaje;
import com.dacrt.SBIABackend.dto.requestDto.DetalleMaestroevaluacionesRequestDto;
import com.dacrt.SBIABackend.dto.requestDto.MaestroevaluacionesRequestDto;
import com.dacrt.SBIABackend.dto.responseDto.DetalleMaestroevaluacionesResponseDto;
import com.dacrt.SBIABackend.dto.responseDto.MaestroevaluacionesResponseDto;
import com.dacrt.SBIABackend.entity.Maestroevaluacion;
import com.dacrt.SBIABackend.entity.Unidad;
import com.dacrt.SBIABackend.service.MaestroevaluacionesService;
import com.dacrt.SBIABackend.service.UnidadService;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/maestroevaluaciones"})
@CrossOrigin(origins={"*"})
public class MaestroevaluacionesControler {
    @Autowired
    private final MaestroevaluacionesService maestroEvaluacionesService;
    @Autowired
    private final UnidadService unidadService;
    Date fechaActual = new Date();
    Logger logger = LoggerFactory.getLogger(MaestroevaluacionesControler.class);

    @Autowired
    public MaestroevaluacionesControler(MaestroevaluacionesService maestroEvaluacionesService, UnidadService unidadService) {
        this.maestroEvaluacionesService = maestroEvaluacionesService;
        this.unidadService = unidadService;
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @PostMapping(value={"/create"})
    public ResponseEntity<MaestroevaluacionesResponseDto> addMaestroevaluaciones(@RequestBody MaestroevaluacionesRequestDto maestroevaluacionesRequestDto) {
        try {
            int valido = 0;
            if (StringUtils.isBlank((CharSequence)maestroevaluacionesRequestDto.getNombreEvaluacion()) || StringUtils.isBlank((CharSequence)maestroevaluacionesRequestDto.getDescripcionEvalua()) || maestroevaluacionesRequestDto.getActivo() == 0 || maestroevaluacionesRequestDto.getFechaApertura() == null || maestroevaluacionesRequestDto.getFechaCorte() == null || maestroevaluacionesRequestDto.getFechaCierre() == null) {
                this.logger.warn("Los campos del Maestro de evaluaci\u00f3n son obligatorios");
                return new ResponseEntity((Object)new Mensaje("Los campos del Maestro de evaluaci\u00f3n son obligatorios"), HttpStatus.BAD_REQUEST);
            }
            if (maestroevaluacionesRequestDto.getNombreEvaluacion().length() > 100 || maestroevaluacionesRequestDto.getDescripcionEvalua().length() > 300 || String.valueOf(maestroevaluacionesRequestDto.getActivo()).length() > 1) {
                this.logger.warn("Verifique el tama\u00f1o del contenido de los campos del Maestro de evaluaci\u00f3n");
                return new ResponseEntity((Object)new Mensaje("Verifique el tama\u00f1o del contenido de los campos del Maestro de evaluaci\u00f3n"), HttpStatus.BAD_REQUEST);
            }
            if (this.maestroEvaluacionesService.existsByNombreEvaluacion(maestroevaluacionesRequestDto.getNombreEvaluacion())) {
                this.logger.warn("Ya se encuentra registrado el nombre del Maestro de evaluaci\u00f3n: " + maestroevaluacionesRequestDto.getNombreEvaluacion());
                return new ResponseEntity((Object)new Mensaje("Ya se encuentra registrado el nombre del maestro de evaluaci\u00f3n: " + maestroevaluacionesRequestDto.getNombreEvaluacion()), HttpStatus.BAD_REQUEST);
            }
            valido = maestroevaluacionesRequestDto.getFechaApertura().compareTo(maestroevaluacionesRequestDto.getFechaCorte()) < 0 && maestroevaluacionesRequestDto.getFechaCorte().compareTo(maestroevaluacionesRequestDto.getFechaCierre()) < 0 && maestroevaluacionesRequestDto.getFechaApertura().compareTo(maestroevaluacionesRequestDto.getFechaCierre()) < 0 ? 0 : -1;
            if (valido == -1) {
                this.logger.warn("La fecha de apertura debe ser mayor que la fecha de corte y de cierre y la fecha de corte debe ser mayor que la fecha de cierre del maestro de evaluaci\u00f3n");
                return new ResponseEntity((Object)new Mensaje("La fecha de apertura debe ser mayor que la fecha de corte y de cierre y la fecha de corte debe ser mayor que la fecha de cierre del maestro de evaluaci\u00f3n"), HttpStatus.BAD_REQUEST);
            }
            Maestroevaluacion maestroEvaluaciones = this.maestroEvaluacionesService.addMaestro(maestroevaluacionesRequestDto);
            MaestroevaluacionesResponseDto maestroevaluacionesResponseDto = new MaestroevaluacionesResponseDto();
            if (maestroEvaluaciones == null) {
                this.logger.info("El Maestro de Evaluaci\u00f3n se ha guardado exit\u00f3samente");
                return new ResponseEntity((Object)maestroevaluacionesResponseDto, HttpStatus.OK);
            }
            this.logger.info("Error: El Maestro de Evaluaci\u00f3n " + maestroevaluacionesRequestDto.getNombreEvaluacion() + "no se ha podido registrar");
            return new ResponseEntity((Object)maestroevaluacionesResponseDto, HttpStatus.OK);
        }
        catch (Exception ex) {
            this.logger.error(ex.getMessage());
            return new ResponseEntity((Object)new Mensaje(ex.getMessage()), HttpStatus.METHOD_NOT_ALLOWED);
        }
    }

    @GetMapping(value={"/detail/{idMaestroEvaluacion}"})
    public ResponseEntity<DetalleMaestroevaluacionesResponseDto> getMaestroevaluacion(@PathVariable Integer idMaestroEvaluacion) {
        if (!this.maestroEvaluacionesService.existsById(idMaestroEvaluacion)) {
            this.logger.warn("No existe el id del Maestro de evaluaci\u00f3n solicitado: " + idMaestroEvaluacion);
            return new ResponseEntity((Object)new Mensaje("No existe el id del Maestro de evaluaci\u00f3n solicitado"), HttpStatus.NOT_FOUND);
        }
        DetalleMaestroevaluacionesResponseDto detalleMaestroevaluacionesResponseDto = this.maestroEvaluacionesService.getMaestroById(idMaestroEvaluacion);
        return new ResponseEntity((Object)detalleMaestroevaluacionesResponseDto, HttpStatus.OK);
    }

    @GetMapping(value={"/listar/{idUnidad}"})
    public ResponseEntity<List<Maestroevaluacion>> buscarMaestrosUnidades(@PathVariable Integer idUnidad) {
        Unidad unidad = this.unidadService.getUnidad(idUnidad);
        List<Maestroevaluacion> maestrosEvaluaciones = this.maestroEvaluacionesService.buscarMaestrosUnidades(unidad);
        return new ResponseEntity(maestrosEvaluaciones, HttpStatus.OK);
    }

    @GetMapping(value={"/lista"})
    public ResponseEntity<List<DetalleMaestroevaluacionesResponseDto>> getMaestroevaluaciones() {
        List<DetalleMaestroevaluacionesResponseDto> detalleMaestroevaluacionesResponseDtos = this.maestroEvaluacionesService.getMaestros();
        return new ResponseEntity(detalleMaestroevaluacionesResponseDtos, HttpStatus.OK);
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @PutMapping(value={"/delete/{idMaestroEvaluacion}"})
    public ResponseEntity<?> deleteMaestroevaluaciones(@RequestBody DetalleMaestroevaluacionesRequestDto detalleMaestroevaluacionesRequestDto, @PathVariable Integer idMaestroEvaluacion) {
        try {
            if (!this.maestroEvaluacionesService.existsById(idMaestroEvaluacion)) {
                this.logger.warn("No existe el id del Maestro de evaluaci\u00f3n solicitado: " + idMaestroEvaluacion);
                return new ResponseEntity((Object)new Mensaje("No existe el id del Maestro de evaluaci\u00f3n solicitado"), HttpStatus.NOT_FOUND);
            }
            Maestroevaluacion maestroevaluaciones = this.maestroEvaluacionesService.getOne(idMaestroEvaluacion).get();
            int valor = maestroevaluaciones.getActivo() == 1 ? 2 : 1;
            maestroevaluaciones.setActivo(valor);
            maestroevaluaciones.setUsuario(maestroevaluaciones.getUsuario());
            maestroevaluaciones.setFechaModificacion(this.fechaActual);
            this.maestroEvaluacionesService.save(maestroevaluaciones);
            if (maestroevaluaciones.getActivo() == 1) {
                this.logger.info("El Maestro de evaluaci\u00f3n con id " + idMaestroEvaluacion + " fue activado");
                return new ResponseEntity((Object)new Mensaje("El Maestro de evaluaci\u00f3n con id " + idMaestroEvaluacion + " fue activado"), HttpStatus.OK);
            }
            this.logger.info("El Maestro de evaluaci\u00f3n con id " + idMaestroEvaluacion + " fue desactivado");
            return new ResponseEntity((Object)new Mensaje("El Maestro de evaluaci\u00f3n con id " + idMaestroEvaluacion + " fue desactivado"), HttpStatus.OK);
        }
        catch (Exception ex) {
            this.logger.error(ex.getMessage());
            return new ResponseEntity((Object)new Mensaje(ex.getMessage()), HttpStatus.METHOD_NOT_ALLOWED);
        }
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @PutMapping(value={"/update/{idMaestroEvaluacion}"})
    public ResponseEntity<MaestroevaluacionesResponseDto> editMaestroevaluaciones(@RequestBody DetalleMaestroevaluacionesRequestDto detalleMaestroevaluacionesRequestDto, @PathVariable Integer idMaestroEvaluacion) {
        try {
            int valido = 0;
            Maestroevaluacion maestroEvaluacion = new Maestroevaluacion();
            if (!this.maestroEvaluacionesService.existsById(idMaestroEvaluacion)) {
                this.logger.warn("No existe el id del Maestro de evaluaci\u00f3n solicitado: " + idMaestroEvaluacion);
                return new ResponseEntity((Object)new Mensaje("No existe el id del Maestro de evaluaci\u00f3n solicitado"), HttpStatus.NOT_FOUND);
            }
            if (StringUtils.isBlank((CharSequence)detalleMaestroevaluacionesRequestDto.getNombreEvaluacion()) || StringUtils.isBlank((CharSequence)detalleMaestroevaluacionesRequestDto.getDescripcionEvalua()) || detalleMaestroevaluacionesRequestDto.getActivo() == 0 || detalleMaestroevaluacionesRequestDto.getFechaApertura() == null || detalleMaestroevaluacionesRequestDto.getFechaCorte() == null || detalleMaestroevaluacionesRequestDto.getFechaCierre() == null) {
                this.logger.warn("Los campos del Maestro de evaluaci\u00f3n son obligatorios");
                return new ResponseEntity((Object)new Mensaje("Los campos del Maestro de evaluaci\u00f3n son obligatorios"), HttpStatus.BAD_REQUEST);
            }
            if (detalleMaestroevaluacionesRequestDto.getNombreEvaluacion().length() > 100 || detalleMaestroevaluacionesRequestDto.getDescripcionEvalua().length() > 300 || String.valueOf(detalleMaestroevaluacionesRequestDto.getActivo()).length() > 1) {
                this.logger.warn("Verifique el tama\u00f1o del contenido de los campos del Maestro de evaluaci\u00f3n");
                return new ResponseEntity((Object)new Mensaje("Verifique el tama\u00f1o del contenido de los campos del Maestro de evaluaci\u00f3n"), HttpStatus.BAD_REQUEST);
            }
            valido = detalleMaestroevaluacionesRequestDto.getFechaApertura().compareTo(detalleMaestroevaluacionesRequestDto.getFechaCorte()) < 0 && detalleMaestroevaluacionesRequestDto.getFechaCorte().compareTo(detalleMaestroevaluacionesRequestDto.getFechaCierre()) < 0 && detalleMaestroevaluacionesRequestDto.getFechaApertura().compareTo(detalleMaestroevaluacionesRequestDto.getFechaCierre()) < 0 ? 0 : -1;
            if (valido == -1) {
                this.logger.warn("La fecha de apertura debe ser mayor que la fecha de corte y de cierre y la fecha de corte debe ser mayor que la fecha de cierre del maestro de evaluaci\u00f3n");
                return new ResponseEntity((Object)new Mensaje("La fecha de apertura debe ser mayor que la fecha de corte y de cierre y la fecha de corte debe ser mayor que la fecha de cierre del maestro de evaluaci\u00f3n"), HttpStatus.BAD_REQUEST);
            }
            if (this.maestroEvaluacionesService.existsByNombreEvaluacion(detalleMaestroevaluacionesRequestDto.getNombreEvaluacion()) && this.maestroEvaluacionesService.getByNombreEvaluacion(detalleMaestroevaluacionesRequestDto.getNombreEvaluacion()).get().getIdMaestroEvaluacion() != idMaestroEvaluacion.intValue()) {
                this.logger.warn("El nombre del maestro de evaluaci\u00f3n ya existe: " + detalleMaestroevaluacionesRequestDto.getNombreEvaluacion());
                return new ResponseEntity((Object)new Mensaje("El nombre del maestro de evaluaci\u00f3n ya existe " + detalleMaestroevaluacionesRequestDto.getNombreEvaluacion()), HttpStatus.BAD_REQUEST);
            }
            MaestroevaluacionesRequestDto maestroevaluacionesRequestDto = new MaestroevaluacionesRequestDto();
            maestroevaluacionesRequestDto.setNombreEvaluacion(detalleMaestroevaluacionesRequestDto.getNombreEvaluacion());
            maestroevaluacionesRequestDto.setDescripcionEvalua(detalleMaestroevaluacionesRequestDto.getDescripcionEvalua());
            maestroevaluacionesRequestDto.setFechaApertura(detalleMaestroevaluacionesRequestDto.getFechaApertura());
            maestroevaluacionesRequestDto.setFechaCorte(detalleMaestroevaluacionesRequestDto.getFechaCorte());
            maestroevaluacionesRequestDto.setFechaCierre(detalleMaestroevaluacionesRequestDto.getFechaCierre());
            maestroevaluacionesRequestDto.setActivo(detalleMaestroevaluacionesRequestDto.getActivo());
            maestroevaluacionesRequestDto.setIdUnidad(detalleMaestroevaluacionesRequestDto.getIdUnidad());
            maestroevaluacionesRequestDto.setUsuario(detalleMaestroevaluacionesRequestDto.getUsuario());
            maestroevaluacionesRequestDto.setFechaModificacion(this.fechaActual);
            maestroevaluacionesRequestDto.setFechaRegistro(detalleMaestroevaluacionesRequestDto.getFechaRegistro());
            maestroEvaluacion = this.maestroEvaluacionesService.editMaestro(idMaestroEvaluacion, maestroevaluacionesRequestDto);
            MaestroevaluacionesResponseDto maestroevaluacionesResponseDto = new MaestroevaluacionesResponseDto();
            if (maestroEvaluacion == null) {
                this.logger.info("El Maestro de Evaluaci\u00f3n " + maestroevaluacionesRequestDto.getNombreEvaluacion() + " se ha actualizado exit\u00f3samente");
                return new ResponseEntity((Object)maestroevaluacionesResponseDto, HttpStatus.OK);
            }
            this.logger.info("Error: El Maestro de Evaluaci\u00f3n " + maestroevaluacionesRequestDto.getNombreEvaluacion() + "no se ha podido actualizar");
            return new ResponseEntity((Object)maestroevaluacionesResponseDto, HttpStatus.OK);
        }
        catch (Exception ex) {
            this.logger.error(ex.getMessage());
            return new ResponseEntity((Object)new Mensaje(ex.getMessage()), HttpStatus.METHOD_NOT_ALLOWED);
        }
    }
}

