/*
 * Decompiled with CFR 0.152.
 */
package com.dacrt.SBIABackend.controler;

import com.dacrt.SBIABackend.dto.Mensaje;
import com.dacrt.SBIABackend.dto.requestDto.LineaOperacionRequestDto;
import com.dacrt.SBIABackend.dto.responseDto.DetalleLineaOperacionResponseDto;
import com.dacrt.SBIABackend.dto.responseDto.LineaOperacionResponseDto;
import com.dacrt.SBIABackend.entity.LineaOperacion;
import com.dacrt.SBIABackend.service.LineaOperacionService;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/lineaoperaciones"})
@CrossOrigin(origins={"*"})
public class LineaOperacionControler {
    private final LineaOperacionService lineaOperacionService;
    Logger logger = LoggerFactory.getLogger(LineaOperacionControler.class);
    Date fechaActual = new Date();

    @Autowired
    public LineaOperacionControler(LineaOperacionService lineaOperacionService) {
        this.lineaOperacionService = lineaOperacionService;
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @PostMapping(value={"/create"})
    public ResponseEntity<LineaOperacionResponseDto> addCanal(@RequestBody LineaOperacionRequestDto lineaOperacionRequestDto) {
        try {
            if (StringUtils.isBlank((CharSequence)lineaOperacionRequestDto.getNombre()) || lineaOperacionRequestDto.getActivo() == 0) {
                this.logger.warn("Los campos son obligatorios");
                return new ResponseEntity((Object)new Mensaje("Los campos son obligatorios"), HttpStatus.BAD_REQUEST);
            }
            if (lineaOperacionRequestDto.getNombre().length() > 300 || String.valueOf(lineaOperacionRequestDto.getActivo()).length() > 1) {
                this.logger.warn("Verifique el tama\u00f1o del contenido de los campos");
                return new ResponseEntity((Object)new Mensaje("Verifique el tama\u00f1o del contenido de los campos"), HttpStatus.BAD_REQUEST);
            }
            if (this.lineaOperacionService.existsByNombre(lineaOperacionRequestDto.getNombre())) {
                this.logger.warn("Ya se encuentra registrado el nombre de la L\u00ednea de Operaci\u00f3n: " + lineaOperacionRequestDto.getNombre());
                return new ResponseEntity((Object)new Mensaje("Ya se encuentra registrado el nombre de la L\u00ednea de Operaci\u00f3n"), HttpStatus.BAD_REQUEST);
            }
            LineaOperacionResponseDto lineaOperacionResponseDto = this.lineaOperacionService.addLineaOperacion(lineaOperacionRequestDto);
            this.logger.info("L\u00ednea de Operaci\u00f3n grabada con \u00e9xito: " + lineaOperacionRequestDto.getNombre());
            return new ResponseEntity((Object)lineaOperacionResponseDto, HttpStatus.OK);
        }
        catch (DataAccessException ex) {
            this.logger.error(ex.getMessage());
            return new ResponseEntity((Object)new Mensaje(ex.getMessage()), HttpStatus.METHOD_NOT_ALLOWED);
        }
    }

    @GetMapping(value={"/detail/{id_lineaoperacion}"})
    public ResponseEntity<DetalleLineaOperacionResponseDto> getLineaOperacion(@PathVariable Integer id_lineaoperacion) {
        if (!this.lineaOperacionService.existsById(id_lineaoperacion)) {
            this.logger.warn("No existe el id de la l\u00ednea de Operaci\u00f3n solicitada: " + id_lineaoperacion);
            return new ResponseEntity((Object)new Mensaje("No existe el id de la l\u00ednea de Operaci\u00f3n solicitada"), HttpStatus.NOT_FOUND);
        }
        DetalleLineaOperacionResponseDto lineaOperacionResponseDto = this.lineaOperacionService.getLineaOperacionById(id_lineaoperacion);
        return new ResponseEntity((Object)lineaOperacionResponseDto, HttpStatus.OK);
    }

    @GetMapping(value={"/lista"})
    public ResponseEntity<List<DetalleLineaOperacionResponseDto>> getLineaOperaciones() {
        List<DetalleLineaOperacionResponseDto> lineaOperacionResponseDtos = this.lineaOperacionService.getLineaOperaciones();
        return new ResponseEntity(lineaOperacionResponseDtos, HttpStatus.OK);
    }

    @GetMapping(value={"/listactivos"})
    public ResponseEntity<List<DetalleLineaOperacionResponseDto>> getLineaOperacionesActivos() {
        List<DetalleLineaOperacionResponseDto> lineaOperacionResponseDtos = this.lineaOperacionService.getLineaOperacionesActivos();
        return new ResponseEntity(lineaOperacionResponseDtos, HttpStatus.OK);
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @PutMapping(value={"/delete/{id_lineaoperacion}"})
    public ResponseEntity<LineaOperacionResponseDto> deleteLineaOperacion(@PathVariable Integer id_lineaoperacion, LineaOperacionRequestDto lineaOperacionRequestDto) {
        try {
            if (!this.lineaOperacionService.existsById(id_lineaoperacion)) {
                this.logger.warn("No existe el id de la l\u00ednea de operaci\u00f3n solicitada: " + id_lineaoperacion);
                return new ResponseEntity((Object)new Mensaje("No existe el id de la l\u00ednea de operaci\u00f3n solicitada"), HttpStatus.NOT_FOUND);
            }
            LineaOperacion linea = this.lineaOperacionService.getLineaOperacion(id_lineaoperacion);
            int valor = linea.getActivo() == 1 ? 2 : 1;
            linea.setNombre(linea.getNombre());
            linea.setActivo(valor);
            linea.setUsuario(linea.getUsuario());
            linea.setFechaModificacion(this.fechaActual);
            linea.setFechaRegistro(linea.getFechaRegistro());
            LineaOperacionRequestDto lineaOperacionRequestDto2 = new LineaOperacionRequestDto();
            lineaOperacionRequestDto2.setNombre(linea.getNombre());
            lineaOperacionRequestDto2.setActivo(valor);
            lineaOperacionRequestDto2.setUsuario(linea.getUsuario());
            lineaOperacionRequestDto2.setFechaModificacion(this.fechaActual);
            lineaOperacionRequestDto2.setFechaRegistro(linea.getFechaRegistro());
            this.lineaOperacionService.deleteLineaOperacion(id_lineaoperacion, lineaOperacionRequestDto2);
            if (linea.getActivo() == 1) {
                this.logger.warn("La l\u00ednea de operaci\u00f3n con id " + id_lineaoperacion + " fue activada");
                return new ResponseEntity((Object)new Mensaje("La l\u00ednea de operaci\u00f3n con id " + id_lineaoperacion + " fue activada"), HttpStatus.OK);
            }
            this.logger.warn("La l\u00ednea de operaci\u00f3n con id " + id_lineaoperacion + " fue desactivada");
            return new ResponseEntity((Object)new Mensaje("La l\u00ednea de operaci\u00f3n con id " + id_lineaoperacion + " fue desactivada"), HttpStatus.OK);
        }
        catch (DataAccessException ex) {
            this.logger.error(ex.getMessage());
            return new ResponseEntity((Object)new Mensaje(ex.getMessage()), HttpStatus.METHOD_NOT_ALLOWED);
        }
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @PutMapping(value={"/update/{id_lineaoperacion}"})
    public ResponseEntity<DetalleLineaOperacionResponseDto> editLineaOperacion(@PathVariable Integer id_lineaoperacion, @RequestBody LineaOperacionRequestDto lineaOperacionRequestDto) {
        try {
            if (!this.lineaOperacionService.existsById(id_lineaoperacion)) {
                this.logger.warn("No existe el id de la l\u00ednea de operaci\u00f3n solicitado: " + id_lineaoperacion);
                return new ResponseEntity((Object)new Mensaje("No existe el id de la l\u00ednea de operaci\u00f3n solicitado"), HttpStatus.NOT_FOUND);
            }
            if (StringUtils.isBlank((CharSequence)lineaOperacionRequestDto.getNombre()) || lineaOperacionRequestDto.getActivo() == 0) {
                this.logger.warn("Los campos son obligatorios");
                return new ResponseEntity((Object)new Mensaje("Los campos son obligatorios"), HttpStatus.BAD_REQUEST);
            }
            if (lineaOperacionRequestDto.getNombre().length() > 300 || String.valueOf(lineaOperacionRequestDto.getActivo()).length() > 1) {
                this.logger.warn("Verifique el tama\u00f1o del contenido de los campos");
                return new ResponseEntity((Object)new Mensaje("Verifique el tama\u00f1o del contenido de los campos"), HttpStatus.BAD_REQUEST);
            }
            if (this.lineaOperacionService.existsByNombre(lineaOperacionRequestDto.getNombre()) && this.lineaOperacionService.getByNombre(lineaOperacionRequestDto.getNombre()).get().getId_lineaoperacion() != id_lineaoperacion.intValue()) {
                this.logger.warn("El nombre de la l\u00ednea de operaci\u00f3n ya existe " + lineaOperacionRequestDto.getNombre());
                return new ResponseEntity((Object)new Mensaje("El nombre de la l\u00ednea de operaci\u00f3n ya existe: " + lineaOperacionRequestDto.getNombre()), HttpStatus.BAD_REQUEST);
            }
            LineaOperacionRequestDto lineaOperacionRequestDto2 = new LineaOperacionRequestDto();
            lineaOperacionRequestDto2.setNombre(lineaOperacionRequestDto.getNombre());
            lineaOperacionRequestDto2.setActivo(lineaOperacionRequestDto.getActivo());
            lineaOperacionRequestDto2.setUsuario(lineaOperacionRequestDto.getUsuario());
            lineaOperacionRequestDto2.setFechaModificacion(lineaOperacionRequestDto.getFechaModificacion());
            lineaOperacionRequestDto2.setFechaRegistro(lineaOperacionRequestDto.getFechaModificacion());
            this.lineaOperacionService.editLineaOperacion(id_lineaoperacion, lineaOperacionRequestDto2);
            DetalleLineaOperacionResponseDto detalleLineaOperacionResponseDto = this.lineaOperacionService.getLineaOperacionById(id_lineaoperacion);
            this.logger.info("La l\u00ednea de operaci\u00f3n fue actualizado " + lineaOperacionRequestDto.getNombre());
            return new ResponseEntity((Object)detalleLineaOperacionResponseDto, HttpStatus.OK);
        }
        catch (DataAccessException ex) {
            this.logger.error(ex.getMessage());
            return new ResponseEntity((Object)new Mensaje(ex.getMessage()), HttpStatus.METHOD_NOT_ALLOWED);
        }
    }
}

