/*
 * Decompiled with CFR 0.152.
 */
package com.dacrt.SBIABackend.controler;

import com.dacrt.SBIABackend.dto.ComponentesdetiDto;
import com.dacrt.SBIABackend.dto.DetalleComponentedetiDto;
import com.dacrt.SBIABackend.dto.Mensaje;
import com.dacrt.SBIABackend.entity.Componentesdeti;
import com.dacrt.SBIABackend.entity.Parametros;
import com.dacrt.SBIABackend.service.ComponentesdetiService;
import com.dacrt.SBIABackend.service.ParametrosService;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/componentesdeti"})
@CrossOrigin(origins={"*"})
public class ComponentesdetiControler {
    @Autowired
    private final ComponentesdetiService componentesdetiService;
    @Autowired
    private final ParametrosService parametrosService;
    Logger logger = LoggerFactory.getLogger(ComponentesdetiControler.class);
    Date fechaActual = new Date();

    @Autowired
    public ComponentesdetiControler(ComponentesdetiService componentesdetiService, ParametrosService parametrosService) {
        this.componentesdetiService = componentesdetiService;
        this.parametrosService = parametrosService;
    }

    @GetMapping(value={"/lista"})
    public ResponseEntity<List<DetalleComponentedetiDto>> list() {
        List<DetalleComponentedetiDto> list = this.componentesdetiService.list();
        return new ResponseEntity(list, HttpStatus.OK);
    }

    @GetMapping(value={"/cantidadComponentes"})
    public ResponseEntity<?> countComponentes() {
        long cantidadComponentes = this.componentesdetiService.countComponentes();
        return new ResponseEntity((Object)cantidadComponentes, HttpStatus.OK);
    }

    @GetMapping(value={"/detail/{id_componentedeti}"})
    public ResponseEntity<DetalleComponentedetiDto> getById(@PathVariable(value="id_componentedeti") Integer id_componentedeti) {
        if (!this.componentesdetiService.existsById(id_componentedeti)) {
            return new ResponseEntity((Object)new Mensaje("No existe el Componente de Tecnolog\u00eda"), HttpStatus.NOT_FOUND);
        }
        Componentesdeti componente = this.componentesdetiService.getOne(id_componentedeti).get();
        Optional<Parametros> deEstatus = this.parametrosService.getByIdtablaAndValor("ESTATUS", String.valueOf(componente.getActivo()));
        if (!deEstatus.isPresent()) {
            return new ResponseEntity((Object)new Mensaje("El tipo de estatus no existe"), HttpStatus.BAD_REQUEST);
        }
        String valor = deEstatus.get().getNombre();
        Optional<Parametros> deTipoComponente = this.parametrosService.getByIdtablaAndValor("TIPOCOMPONENTE", String.valueOf(componente.getTipoComponente()));
        if (!deTipoComponente.isPresent()) {
            return new ResponseEntity((Object)new Mensaje("El tipo de componente no existe"), HttpStatus.BAD_REQUEST);
        }
        String valor2 = deTipoComponente.get().getNombre();
        DetalleComponentedetiDto componenteDto = new DetalleComponentedetiDto();
        componenteDto.setId_componentedeti(id_componentedeti);
        componenteDto.setNombre(componente.getNombre());
        componenteDto.setDescripcion(componente.getDescripcion());
        componenteDto.setTipoComponente(componente.getTipoComponente());
        componenteDto.setDeTipoComponente(valor2);
        componenteDto.setUbicacion(componente.getUbicacion());
        componenteDto.setActivo(componente.getActivo());
        componenteDto.setDeActivo(valor);
        componenteDto.setUsuario(componente.getUsuario());
        componenteDto.setFechaRegistro(componente.getFechaRegistro());
        componenteDto.setFechaRegistro(componente.getFechaRegistro());
        return new ResponseEntity((Object)componenteDto, HttpStatus.OK);
    }

    @GetMapping(value={"/detailname/{nombre}"})
    public ResponseEntity<Componentesdeti> getByNombre(@PathVariable(value="nombre") String nombre) {
        if (!this.componentesdetiService.existsByNombre(nombre)) {
            return new ResponseEntity((Object)new Mensaje("No existe el Componente de Tecnolog\u00eda"), HttpStatus.NOT_FOUND);
        }
        Componentesdeti componentesdeti = this.componentesdetiService.getByNombre(nombre).get();
        return new ResponseEntity((Object)componentesdeti, HttpStatus.OK);
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @PostMapping(value={"/create"})
    public ResponseEntity<?> create(@RequestBody ComponentesdetiDto componentesdetiDto) {
        try {
            if (StringUtils.isBlank((CharSequence)componentesdetiDto.getNombre()) || StringUtils.isBlank((CharSequence)componentesdetiDto.getDescripcion()) || StringUtils.isBlank((CharSequence)componentesdetiDto.getUbicacion()) || componentesdetiDto.getActivo() == 0 || componentesdetiDto.getTipoComponente() == 0) {
                return new ResponseEntity((Object)new Mensaje("Los campos son obligatorios"), HttpStatus.BAD_REQUEST);
            }
            if (componentesdetiDto.getNombre().length() > 200 || componentesdetiDto.getDescripcion().length() > 300 || componentesdetiDto.getUbicacion().length() > 400 || String.valueOf(componentesdetiDto.getActivo()).length() > 1 || String.valueOf(componentesdetiDto.getTipoComponente()).length() > 6) {
                return new ResponseEntity((Object)new Mensaje("Verifique el tama\u00f1o del contenido de los campos"), HttpStatus.BAD_REQUEST);
            }
            if (this.componentesdetiService.existsByNombre(componentesdetiDto.getNombre())) {
                return new ResponseEntity((Object)new Mensaje("El nombre del Componente ya existe"), HttpStatus.BAD_REQUEST);
            }
            Componentesdeti componente = new Componentesdeti(componentesdetiDto.getNombre(), componentesdetiDto.getDescripcion(), componentesdetiDto.getTipoComponente(), componentesdetiDto.getUbicacion(), componentesdetiDto.getActivo(), componentesdetiDto.getUsuario(), componentesdetiDto.getFechaRegistro(), this.fechaActual);
            this.componentesdetiService.save(componente);
            return new ResponseEntity((Object)new Mensaje("Componente de Tecnolog\u00eda creado"), HttpStatus.OK);
        }
        catch (DataAccessException ex) {
            this.logger.error(ex.getMessage());
            return new ResponseEntity((Object)new Mensaje(ex.getMessage()), HttpStatus.METHOD_NOT_ALLOWED);
        }
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @PutMapping(value={"/update/{id_componentedeti}"})
    public ResponseEntity<DetalleComponentedetiDto> update(@RequestBody DetalleComponentedetiDto detalleComponentesdetiDto, @PathVariable(value="id_componentedeti") Integer id_componentedeti) {
        try {
            if (!this.componentesdetiService.existsById(id_componentedeti)) {
                return new ResponseEntity((Object)new Mensaje("No existe el Componente de Tecnolog\u00eda"), HttpStatus.NOT_FOUND);
            }
            if (StringUtils.isBlank((CharSequence)detalleComponentesdetiDto.getNombre()) || StringUtils.isBlank((CharSequence)detalleComponentesdetiDto.getDescripcion()) || StringUtils.isBlank((CharSequence)detalleComponentesdetiDto.getUbicacion()) || detalleComponentesdetiDto.getActivo() == 0 || detalleComponentesdetiDto.getTipoComponente() == 0) {
                return new ResponseEntity((Object)new Mensaje("Los campos son obligatorios"), HttpStatus.BAD_REQUEST);
            }
            if (detalleComponentesdetiDto.getNombre().length() > 200 || detalleComponentesdetiDto.getDescripcion().length() > 300 || detalleComponentesdetiDto.getUbicacion().length() > 400 || String.valueOf(detalleComponentesdetiDto.getActivo()).length() > 1 || String.valueOf(detalleComponentesdetiDto.getTipoComponente()).length() > 6) {
                return new ResponseEntity((Object)new Mensaje("Verifique el tama\u00f1o del contenido de los campos"), HttpStatus.BAD_REQUEST);
            }
            if (this.componentesdetiService.existsByNombre(detalleComponentesdetiDto.getNombre()) && this.componentesdetiService.getByNombre(detalleComponentesdetiDto.getNombre()).get().getId_componentedeti() != id_componentedeti.intValue()) {
                return new ResponseEntity((Object)new Mensaje("ese nombre ya existe"), HttpStatus.BAD_REQUEST);
            }
            Componentesdeti componentesdeti = this.componentesdetiService.getOne(id_componentedeti).get();
            componentesdeti.setNombre(detalleComponentesdetiDto.getNombre());
            componentesdeti.setDescripcion(detalleComponentesdetiDto.getDescripcion());
            componentesdeti.setTipoComponente(detalleComponentesdetiDto.getTipoComponente());
            componentesdeti.setUbicacion(detalleComponentesdetiDto.getUbicacion());
            componentesdeti.setActivo(detalleComponentesdetiDto.getActivo());
            componentesdeti.setFechaModificacion(this.fechaActual);
            componentesdeti.setFechaRegistro(detalleComponentesdetiDto.getFechaRegistro());
            this.componentesdetiService.save(componentesdeti);
            DetalleComponentedetiDto detalleComponente = this.componentesdetiService.getComponenteById(id_componentedeti);
            return new ResponseEntity((Object)detalleComponente, HttpStatus.OK);
        }
        catch (DataAccessException ex) {
            this.logger.error(ex.getMessage());
            return new ResponseEntity((Object)new Mensaje(ex.getMessage()), HttpStatus.METHOD_NOT_ALLOWED);
        }
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @PutMapping(value={"/delete/{id_componentedeti}"})
    public ResponseEntity<?> delete(@PathVariable(value="id_componentedeti") Integer id_componentedeti, @RequestBody ComponentesdetiDto componentesdetiDto) {
        try {
            if (!this.componentesdetiService.existsById(id_componentedeti)) {
                return new ResponseEntity((Object)new Mensaje("No existe el id del componente solicitado"), HttpStatus.NOT_FOUND);
            }
            System.out.print("Pase");
            Componentesdeti componente = this.componentesdetiService.getOne(id_componentedeti).get();
            int valor = componente.getActivo() == 1 ? 2 : 1;
            componente.setNombre(componente.getNombre());
            componente.setDescripcion(componente.getDescripcion());
            componente.setTipoComponente(componente.getTipoComponente());
            componente.setUbicacion(componente.getUbicacion());
            componente.setActivo(valor);
            componente.setUsuario(componente.getUsuario());
            componente.setFechaModificacion(this.fechaActual);
            componente.setFechaRegistro(componente.getFechaRegistro());
            this.componentesdetiService.save(componente);
            return new ResponseEntity((Object)new Mensaje("El componente con id " + id_componentedeti + " fue activado"), HttpStatus.OK);
        }
        catch (DataAccessException ex) {
            this.logger.error(ex.getMessage());
            return new ResponseEntity((Object)new Mensaje(ex.getMessage()), HttpStatus.METHOD_NOT_ALLOWED);
        }
    }
}

