/*
 * Decompiled with CFR 0.152.
 */
package com.dacrt.SBIABackend.controler;

import com.dacrt.SBIABackend.dto.CargosDto;
import com.dacrt.SBIABackend.dto.DetalleCargosDto;
import com.dacrt.SBIABackend.dto.Mensaje;
import com.dacrt.SBIABackend.dto.requestDto.DetalleCargoRequestDto;
import com.dacrt.SBIABackend.dto.responseDto.DetalleCargoResponseDto;
import com.dacrt.SBIABackend.entity.Cargos;
import com.dacrt.SBIABackend.entity.Parametros;
import com.dacrt.SBIABackend.service.CargosService;
import com.dacrt.SBIABackend.service.ParametrosService;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/cargos"})
@CrossOrigin(origins={"*"})
public class CargosControler {
    private final CargosService cargosService;
    private final ParametrosService parametrosService;
    Logger logger = LoggerFactory.getLogger(CargosControler.class);
    Date fechaActual = new Date();

    @Autowired
    public CargosControler(CargosService cargosService, ParametrosService parametrosService) {
        this.cargosService = cargosService;
        this.parametrosService = parametrosService;
    }

    @GetMapping(value={"/lista"})
    public ResponseEntity<List<DetalleCargosDto>> list() {
        List<DetalleCargosDto> list = this.cargosService.list();
        return new ResponseEntity(list, HttpStatus.OK);
    }

    @GetMapping(value={"/detail/{id_cargos}"})
    public ResponseEntity<DetalleCargosDto> getById(@PathVariable(value="id_cargos") Integer id_cargos) {
        if (!this.cargosService.existsById(id_cargos)) {
            return new ResponseEntity((Object)new Mensaje("No existe el Cargo"), HttpStatus.NOT_FOUND);
        }
        Cargos cargos = this.cargosService.getOne(id_cargos).get();
        Optional<Parametros> deEstatus = this.parametrosService.getByIdtablaAndValor("ESTATUS", String.valueOf(cargos.getActivo()));
        if (!deEstatus.isPresent()) {
            return new ResponseEntity((Object)new Mensaje("El tipo de estatus no existe"), HttpStatus.BAD_REQUEST);
        }
        String valor = deEstatus.get().getNombre();
        DetalleCargosDto cargoDto = new DetalleCargosDto();
        cargoDto.setId_cargos(id_cargos);
        cargoDto.setNombre(cargos.getNombre());
        cargoDto.setDescripcion(cargos.getDescripcion());
        cargoDto.setActivo(cargos.getActivo());
        cargoDto.setDeActivo(valor);
        cargoDto.setUsuario(cargos.getUsuario());
        cargoDto.setFechaRegistro(cargos.getFechaRegistro());
        cargoDto.setFechaModificacion(cargos.getFechaModificacion());
        return new ResponseEntity((Object)cargoDto, HttpStatus.OK);
    }

    @GetMapping(value={"/detailname/{nombre}"})
    public ResponseEntity<Cargos> getByNombre(@PathVariable(value="nombre") String nombre) {
        if (!this.cargosService.existsByNombre(nombre)) {
            return new ResponseEntity((Object)new Mensaje("No existe el Cargo"), HttpStatus.NOT_FOUND);
        }
        Cargos cargos = this.cargosService.getByNombre(nombre).get();
        return new ResponseEntity((Object)cargos, HttpStatus.OK);
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @PostMapping(value={"/create"})
    public ResponseEntity<?> create(@RequestBody CargosDto cargosDto) {
        try {
            if (StringUtils.isBlank((CharSequence)cargosDto.getNombre()) || StringUtils.isBlank((CharSequence)cargosDto.getDescripcion()) || cargosDto.getActivo() == 0) {
                return new ResponseEntity((Object)new Mensaje("Los campos son obligatorios"), HttpStatus.BAD_REQUEST);
            }
            if (cargosDto.getNombre().length() > 100 || cargosDto.getDescripcion().length() > 300 || String.valueOf(cargosDto.getActivo()).length() > 1) {
                return new ResponseEntity((Object)new Mensaje("Verifique el tama\u00f1o del contenido de los campos"), HttpStatus.BAD_REQUEST);
            }
            if (this.cargosService.existsByNombre(cargosDto.getNombre())) {
                return new ResponseEntity((Object)new Mensaje("El nombre del Cargo ya existe"), HttpStatus.BAD_REQUEST);
            }
            Cargos cargos = new Cargos(cargosDto.getNombre(), cargosDto.getDescripcion(), cargosDto.getActivo(), cargosDto.getUsuario(), cargosDto.getFechaRegistro(), cargosDto.getFechaModificacion());
            this.cargosService.save(cargos);
            return new ResponseEntity((Object)new Mensaje("Cargo creado"), HttpStatus.OK);
        }
        catch (DataAccessException ex) {
            this.logger.error(ex.getMessage());
            return new ResponseEntity((Object)new Mensaje(ex.getMessage()), HttpStatus.METHOD_NOT_ALLOWED);
        }
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @PutMapping(value={"/update/{id_cargos}"})
    public ResponseEntity<DetalleCargoResponseDto> update(@RequestBody DetalleCargoRequestDto detalleCargoRequestDto, @PathVariable(value="id_cargos") Integer id_cargos) {
        try {
            if (!this.cargosService.existsById(id_cargos)) {
                return new ResponseEntity((Object)new Mensaje("No existe el Cargo"), HttpStatus.NOT_FOUND);
            }
            if (this.cargosService.existsByNombre(detalleCargoRequestDto.getNombre()) && this.cargosService.getByNombre(detalleCargoRequestDto.getNombre()).get().getId_cargos() != id_cargos.intValue()) {
                return new ResponseEntity((Object)new Mensaje("El nombre del Cargo ya existe"), HttpStatus.BAD_REQUEST);
            }
            if (StringUtils.isBlank((CharSequence)detalleCargoRequestDto.getNombre())) {
                return new ResponseEntity((Object)new Mensaje("El nombre del Cargo es obligatorio"), HttpStatus.BAD_REQUEST);
            }
            Cargos cargos = this.cargosService.getOne(id_cargos).get();
            cargos.setNombre(detalleCargoRequestDto.getNombre());
            cargos.setDescripcion(detalleCargoRequestDto.getDescripcion());
            cargos.setActivo(detalleCargoRequestDto.getActivo());
            cargos.setUsuario(detalleCargoRequestDto.getUsuario());
            cargos.setFechaModificacion(detalleCargoRequestDto.getFechaModificacion());
            cargos.setFechaRegistro(detalleCargoRequestDto.getFechaRegistro());
            this.cargosService.save(cargos);
            this.cargosService.getCargosById(id_cargos);
            return new ResponseEntity((Object)new Mensaje("Cargo actualizado"), HttpStatus.OK);
        }
        catch (DataAccessException ex) {
            this.logger.error(ex.getMessage());
            return new ResponseEntity((Object)new Mensaje(ex.getMessage()), HttpStatus.METHOD_NOT_ALLOWED);
        }
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @PutMapping(value={"/delete/{id_cargos}"})
    public ResponseEntity<?> delete(@RequestBody CargosDto cargosDto, @PathVariable(value="id_cargos") Integer id_cargos) {
        try {
            if (!this.cargosService.existsById(id_cargos)) {
                return new ResponseEntity((Object)new Mensaje("No existe el id del cargo solicitado"), HttpStatus.NOT_FOUND);
            }
            Cargos cargo = this.cargosService.getOne(id_cargos).get();
            int valor = cargo.getActivo() == 1 ? 2 : 1;
            cargo.setNombre(cargo.getNombre());
            cargo.setDescripcion(cargo.getDescripcion());
            cargo.setActivo(valor);
            cargo.setUsuario(cargo.getUsuario());
            cargo.setFechaModificacion(this.fechaActual);
            cargo.setFechaRegistro(cargo.getFechaRegistro());
            this.cargosService.save(cargo);
            if (cargo.getActivo() == 1) {
                return new ResponseEntity((Object)new Mensaje("El cargo con id " + id_cargos + " fue activado"), HttpStatus.OK);
            }
            return new ResponseEntity((Object)new Mensaje("El cargo con id " + id_cargos + " fue desactivado"), HttpStatus.OK);
        }
        catch (DataAccessException ex) {
            this.logger.error(ex.getMessage());
            return new ResponseEntity((Object)new Mensaje(ex.getMessage()), HttpStatus.METHOD_NOT_ALLOWED);
        }
    }
}

